/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class SetBase.
 * 
 * @version $Revision$ $Date$
 */
public class SetBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field includes
     */
    private java.util.List includes;

    /**
     * Field excludes
     */
    private java.util.List excludes;

    /**
     * Field fileMode
     */
    private String fileMode = "0644";

    /**
     * Field directoryMode
     */
    private String directoryMode = "0755";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude
     * 
     * @param string
     */
    public void addExclude(String string)
    {
        getExcludes().add( string );
    } //-- void addExclude(String) 

    /**
     * Method addInclude
     * 
     * @param string
     */
    public void addInclude(String string)
    {
        getIncludes().add( string );
    } //-- void addInclude(String) 

    /**
     * Method getDirectoryMode
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode() 

    /**
     * Method getExcludes
     */
    public java.util.List getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList();
        }
        
        return this.excludes;
    } //-- java.util.List getExcludes() 

    /**
     * Method getFileMode
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode() 

    /**
     * Method getIncludes
     */
    public java.util.List getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList();
        }
        
        return this.includes;
    } //-- java.util.List getIncludes() 

    /**
     * Method getOutputDirectory
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Method removeExclude
     * 
     * @param string
     */
    public void removeExclude(String string)
    {
        getExcludes().remove( string );
    } //-- void removeExclude(String) 

    /**
     * Method removeInclude
     * 
     * @param string
     */
    public void removeInclude(String string)
    {
        getIncludes().remove( string );
    } //-- void removeInclude(String) 

    /**
     * Method setDirectoryMode
     * 
     * @param directoryMode
     */
    public void setDirectoryMode(String directoryMode)
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode(String) 

    /**
     * Method setExcludes
     * 
     * @param excludes
     */
    public void setExcludes(java.util.List excludes)
    {
        this.excludes = excludes;
    } //-- void setExcludes(java.util.List) 

    /**
     * Method setFileMode
     * 
     * @param fileMode
     */
    public void setFileMode(String fileMode)
    {
        this.fileMode = fileMode;
    } //-- void setFileMode(String) 

    /**
     * Method setIncludes
     * 
     * @param includes
     */
    public void setIncludes(java.util.List includes)
    {
        this.includes = includes;
    } //-- void setIncludes(java.util.List) 

    /**
     * Method setOutputDirectory
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

}
