/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.artifact.buildinfo.JdkToolchainUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.toolchain.Toolchain;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

class BuildInfoWriter {
    private final Log log;
    private final PrintWriter p;
    private final boolean mono;
    private final RuntimeInformation rtInformation;
    private final Map<Artifact, String> artifacts = new LinkedHashMap<Artifact, String>();
    private int projectCount = -1;
    private boolean ignoreJavadoc = true;
    private List<PathMatcher> ignore;
    private Toolchain toolchain;

    BuildInfoWriter(Log log, PrintWriter p, boolean mono, RuntimeInformation rtInformation) {
        this.log = log;
        this.p = p;
        this.mono = mono;
        this.rtInformation = rtInformation;
    }

    void printHeader(MavenProject project, MavenProject aggregate, boolean reproducible) {
        this.p.println("# https://reproducible-builds.org/docs/jvm/");
        this.p.println("buildinfo.version=1.0-SNAPSHOT");
        this.p.println();
        this.p.println("name=" + project.getName());
        this.p.println("group-id=" + project.getGroupId());
        this.p.println("artifact-id=" + project.getArtifactId());
        this.p.println("version=" + project.getVersion());
        this.p.println();
        this.printSourceInformation(project);
        this.p.println();
        this.p.println("# build instructions");
        this.p.println("build-tool=mvn");
        this.p.println();
        if (reproducible) {
            this.p.println("# build environment information (simplified for reproducibility)");
            this.p.println("java.version=" + BuildInfoWriter.extractJavaMajorVersion(System.getProperty("java.version")));
            String ls = System.lineSeparator();
            this.p.println("os.name=" + ("\n".equals(ls) ? "Unix" : "Windows"));
        } else {
            this.p.println("# effective build environment information");
            this.p.println("java.version=" + System.getProperty("java.version"));
            this.p.println("java.vendor=" + System.getProperty("java.vendor"));
            this.p.println("os.name=" + System.getProperty("os.name"));
            this.p.println("os.version=" + System.getProperty("os.version"));
            this.p.println("os.arch=" + System.getProperty("os.arch"));
            this.p.println("line.separator=" + System.lineSeparator().replace("\r", "\\r").replace("\n", "\\n"));
        }
        this.p.println();
        this.p.println("# Maven rebuild instructions and effective environment");
        if (!reproducible) {
            this.p.println("mvn.version=" + this.rtInformation.getMavenVersion());
        }
        if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
            this.p.println("mvn.minimum.version=" + project.getPrerequisites().getMaven());
        }
        if (this.toolchain != null) {
            String javaVersion = JdkToolchainUtil.getJavaVersion(this.toolchain);
            if (reproducible) {
                javaVersion = BuildInfoWriter.extractJavaMajorVersion(javaVersion);
            }
            this.p.println("mvn.toolchain.jdk=" + javaVersion);
        }
        if (!this.mono && aggregate != null) {
            this.p.println("mvn.aggregate.artifact-id=" + aggregate.getArtifactId());
        }
        this.p.println();
        this.p.println("# " + (this.mono ? "" : "aggregated ") + "output");
    }

    private static String extractJavaMajorVersion(String javaVersion) {
        int index;
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        if ((index = javaVersion.indexOf(46)) < 0) {
            index = javaVersion.indexOf(45);
        }
        return index < 0 ? javaVersion : javaVersion.substring(0, index);
    }

    private void printSourceInformation(MavenProject project) {
        boolean sourceAvailable = false;
        this.p.println("# source information");
        if (project.getScm() != null) {
            sourceAvailable = true;
            this.p.println("source.scm.uri=" + project.getScm().getConnection());
            this.p.println("source.scm.tag=" + project.getScm().getTag());
        } else {
            this.p.println("# no scm configured in pom.xml");
        }
        if (!sourceAvailable) {
            this.log.warn((CharSequence)"No source information available in buildinfo for rebuilders...");
        }
    }

    void printArtifacts(MavenProject project) throws MojoExecutionException {
        String prefix = "outputs.";
        if (!this.mono) {
            ++this.projectCount;
            prefix = prefix + this.projectCount + ".";
            this.p.println();
            this.p.println(prefix + "coordinates=" + project.getGroupId() + ':' + project.getArtifactId());
        }
        Artifact consumerPom = RepositoryUtils.toArtifacts((Collection)project.getAttachedArtifacts()).stream().filter(a -> "pom".equals(a.getExtension()) && "consumer".equals(a.getClassifier())).findAny().orElse(null);
        int n = 0;
        DefaultArtifact pomArtifact = new DefaultArtifact(project.getGroupId(), project.getArtifactId(), null, "pom", project.getVersion());
        if (consumerPom != null) {
            try {
                Path pomFile = Files.createTempFile(Paths.get(project.getBuild().getDirectory(), new String[0]), "consumer-", ".pom", new FileAttribute[0]);
                Files.copy(consumerPom.getFile().toPath(), pomFile, StandardCopyOption.REPLACE_EXISTING);
                pomArtifact = pomArtifact.setFile(pomFile.toFile());
            }
            catch (IOException e) {
                this.p.println("Error processing consumer POM: " + e);
            }
        } else {
            pomArtifact = pomArtifact.setFile(project.getFile());
        }
        this.artifacts.put((Artifact)pomArtifact, prefix + n);
        if (this.isIgnore((Artifact)pomArtifact)) {
            this.p.println("# ignored " + BuildInfoWriter.getArtifactFilename((Artifact)pomArtifact));
        } else {
            this.printFile(prefix + n++, pomArtifact.getGroupId(), pomArtifact.getFile(), project.getArtifactId() + '-' + project.getVersion() + ".pom");
        }
        if (consumerPom != null) {
            DefaultArtifact buildPomArtifact = new DefaultArtifact(project.getGroupId(), project.getArtifactId(), "build", "pom", project.getVersion());
            if (this.isIgnore((Artifact)(buildPomArtifact = buildPomArtifact.setFile(project.getFile())))) {
                this.p.println("# ignored " + BuildInfoWriter.getArtifactFilename((Artifact)buildPomArtifact));
            } else {
                this.artifacts.put((Artifact)buildPomArtifact, prefix + n);
                this.printFile(prefix + n++, buildPomArtifact.getGroupId(), buildPomArtifact.getFile(), project.getArtifactId() + '-' + project.getVersion() + "-build.pom");
            }
        }
        if (project.getArtifact() == null) {
            return;
        }
        if (project.getArtifact().getFile() != null) {
            Artifact main = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact());
            if (this.isIgnore(main)) {
                this.p.println("# ignored " + BuildInfoWriter.getArtifactFilename(main));
            } else {
                this.printArtifact(prefix, n++, RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact()));
            }
        }
        for (Artifact attached : RepositoryUtils.toArtifacts((Collection)project.getAttachedArtifacts())) {
            if ("pom".equals(attached.getExtension()) && "consumer".equals(attached.getClassifier()) || attached.getExtension().endsWith(".asc") || this.ignoreJavadoc && "javadoc".equals(attached.getClassifier())) continue;
            if (this.isIgnore(attached)) {
                this.p.println("# ignored " + BuildInfoWriter.getArtifactFilename(attached));
                this.artifacts.put(attached, null);
                continue;
            }
            this.printArtifact(prefix, n++, attached);
        }
    }

    private void printArtifact(String prefix, int i, Artifact artifact) throws MojoExecutionException {
        prefix = prefix + i;
        File artifactFile = artifact.getFile();
        if (artifactFile.isDirectory()) {
            if ("pom".equals(artifact.getExtension())) {
                return;
            }
            throw new MojoExecutionException("Artifact " + ArtifactIdUtils.toId((Artifact)artifact) + " points to a directory: " + artifactFile + ". Packaging should be 'pom'?");
        }
        if (!artifactFile.isFile()) {
            this.log.warn((CharSequence)("Ignoring artifact " + ArtifactIdUtils.toId((Artifact)artifact) + " because it points to inexistent " + artifactFile));
            return;
        }
        this.printFile(prefix, artifact.getGroupId(), artifact.getFile(), BuildInfoWriter.getArtifactFilename(artifact));
        this.artifacts.put(artifact, prefix);
    }

    static String getArtifactFilename(Artifact artifact) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getArtifactId()).append('-').append(artifact.getBaseVersion());
        if (!artifact.getClassifier().isEmpty()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (!artifact.getExtension().isEmpty()) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    void printFile(String prefix, String groupId, File file) throws MojoExecutionException {
        this.printFile(prefix, groupId, file, file.getName());
    }

    private void printFile(String prefix, String groupId, File file, String filename) throws MojoExecutionException {
        this.p.println();
        this.p.println(prefix + ".groupId=" + groupId);
        this.p.println(prefix + ".filename=" + filename);
        this.p.println(prefix + ".length=" + file.length());
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.p.println(prefix + ".checksums.sha512=" + DigestUtils.sha512Hex((InputStream)is));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error processing file " + file, (Exception)ioe);
        }
        catch (IllegalArgumentException iae) {
            throw new MojoExecutionException("Could not get hash algorithm", iae.getCause());
        }
    }

    Map<Artifact, String> getArtifacts() {
        return this.artifacts;
    }

    static Properties loadOutputProperties(File buildinfo) throws MojoExecutionException {
        Properties prop = new Properties();
        if (buildinfo != null) {
            try (InputStream is = Files.newInputStream(buildinfo.toPath(), new OpenOption[0]);){
                prop.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String name : prop.stringPropertyNames()) {
            if (name.startsWith("outputs.") && !name.endsWith(".coordinates")) continue;
            prop.remove(name);
        }
        return prop;
    }

    boolean getIgnoreJavadoc() {
        return this.ignoreJavadoc;
    }

    void setIgnoreJavadoc(boolean ignoreJavadoc) {
        this.ignoreJavadoc = ignoreJavadoc;
    }

    void setIgnore(List<String> ignore) {
        FileSystem fs = FileSystems.getDefault();
        this.ignore = ignore.stream().map(i -> fs.getPathMatcher("glob:" + i)).collect(Collectors.toList());
    }

    boolean isIgnore(Artifact attached) {
        Path path = Paths.get(attached.getGroupId() + '/' + BuildInfoWriter.getArtifactFilename(attached), new String[0]);
        return this.ignore.stream().anyMatch(m -> m.matches(path));
    }

    public void setToolchain(Toolchain toolchain) {
        this.toolchain = toolchain;
    }
}

