/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.maven.plugin.MojoExecutionException;

class DigestHelper {
    DigestHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String calculateSha512(File file) throws MojoExecutionException {
        try (FileInputStream fis = new FileInputStream(file);){
            MessageDigest messageDigest = MessageDigest.getInstance("sha-512");
            byte[] buffer = new byte[16384];
            int size = fis.read(buffer, 0, buffer.length);
            while (size >= 0) {
                messageDigest.update(buffer, 0, size);
                size = fis.read(buffer, 0, buffer.length);
            }
            String string = Hex.encodeHexString((byte[])messageDigest.digest());
            return string;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error opening file " + file, (Exception)ioe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new MojoExecutionException("Could not get hash algorithm", (Exception)nsae);
        }
    }
}

