/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.converter.tag.block;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.converter.tag.LinkUtils;
import org.apache.maven.tools.plugin.extractor.annotations.converter.tag.block.JavadocBlockTagToHtmlConverter;

@Named(value="see")
@Singleton
public class SeeTagConverter
extends JavadocBlockTagToHtmlConverter {
    private static final String ATTRIBUTE_NAME_IS_FIRST_REFERENCE = "SeeTagletConverter.isFirstReference";

    @Override
    public String convert(String value, ConverterContext context) {
        StringBuilder htmlBuilder = new StringBuilder();
        Boolean isFirstReference = context.getAttribute(ATTRIBUTE_NAME_IS_FIRST_REFERENCE, Boolean.class, Boolean.TRUE);
        if (Boolean.TRUE.equals(isFirstReference)) {
            htmlBuilder.append("<br/><strong>See also:</strong>\n");
            context.setAttribute(ATTRIBUTE_NAME_IS_FIRST_REFERENCE, Boolean.FALSE);
        } else {
            htmlBuilder.append(", ");
        }
        if (value.startsWith("<a href")) {
            return htmlBuilder.append(value).toString();
        }
        if (value.startsWith("\"")) {
            return htmlBuilder.append(value).toString();
        }
        String link = LinkUtils.createLink(value, context);
        htmlBuilder.append(link);
        return htmlBuilder.toString();
    }
}

