/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.test.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.test.plugin.ProjectTool;
import org.apache.maven.shared.test.plugin.RepositoryTool;
import org.apache.maven.shared.test.plugin.TestToolsException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;

@Component(role=ComponentTestTool.class)
public class ComponentTestTool {
    public static final String ROLE = ComponentTestTool.class.getName();
    @Requirement
    private ProjectTool projectTool;
    @Requirement
    private RepositoryTool repositoryTool;

    public File prepareComponentForIntegrationTesting(File pomFile, String testVersion) throws TestToolsException {
        return this.prepareForTesting(pomFile, testVersion, false, null);
    }

    public File prepareComponentForUnitTestingWithMavenBuilds(File pomFile, String testVersion) throws TestToolsException {
        return this.prepareForTesting(pomFile, testVersion, true, null);
    }

    public File prepareComponentForIntegrationTesting(File pomFile, String testVersion, File localRepositoryDir) throws TestToolsException {
        return this.prepareForTesting(pomFile, testVersion, false, localRepositoryDir);
    }

    public File prepareComponentForUnitTestingWithMavenBuilds(File pomFile, String testVersion, File localRepositoryDir) throws TestToolsException {
        return this.prepareForTesting(pomFile, testVersion, true, localRepositoryDir);
    }

    private File prepareForTesting(File pomFile, String testVersion, boolean skipUnitTests, File localRepositoryDir) throws TestToolsException {
        File realProjectDir = pomFile.getParentFile();
        try {
            realProjectDir = realProjectDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new TestToolsException("Failed to stage component for testing.", e);
        }
        try {
            final File tmpDir = File.createTempFile("component-IT-staging-project", "");
            tmpDir.delete();
            tmpDir.mkdirs();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    try {
                        FileUtils.deleteDirectory((File)tmpDir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
            FileUtils.copyDirectoryStructure((File)realProjectDir, (File)tmpDir);
        }
        catch (IOException e) {
            throw new TestToolsException("Failed to create temporary staging directory for component project.", e);
        }
        File buildLog = new File("target/test-build-logs/setup.build.log");
        buildLog.getParentFile().mkdirs();
        File localRepoDir = localRepositoryDir;
        if (localRepoDir == null) {
            localRepoDir = new File("target/test-local-repository");
        }
        MavenProject project = this.projectTool.packageProjectArtifact(pomFile, testVersion, skipUnitTests, buildLog);
        this.repositoryTool.createLocalRepositoryFromComponentProject(project, new File(realProjectDir, "pom.xml"), localRepoDir);
        return localRepoDir;
    }
}

