/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugin.testing.WithoutMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Deprecated
public class MojoRule
implements TestRule {
    private final AbstractMojoTestCase testCase;

    public MojoRule() {
        this(new AbstractMojoTestCase(){});
    }

    public MojoRule(AbstractMojoTestCase testCase) {
        this.testCase = testCase;
    }

    protected void before() throws Throwable {
    }

    protected void after() {
    }

    public InputStream getPublicDescriptorStream() throws Exception {
        return this.testCase.getPublicDescriptorStream();
    }

    public String getPluginDescriptorPath() {
        return this.testCase.getPluginDescriptorPath();
    }

    public String getPluginDescriptorLocation() {
        return this.testCase.getPluginDescriptorLocation();
    }

    public void setupContainer() {
        this.testCase.setupContainer();
    }

    public ContainerConfiguration setupContainerConfiguration() {
        return this.testCase.setupContainerConfiguration();
    }

    public PlexusContainer getContainer() {
        return this.testCase.getContainer();
    }

    public <T extends Mojo> T lookupMojo(String goal, String pluginPom) throws Exception {
        return this.testCase.lookupMojo(goal, pluginPom);
    }

    public <T extends Mojo> T lookupEmptyMojo(String goal, String pluginPom) throws Exception {
        return this.testCase.lookupEmptyMojo(goal, new File(pluginPom));
    }

    public <T extends Mojo> T lookupMojo(String goal, File pom) throws Exception {
        return this.testCase.lookupMojo(goal, pom);
    }

    public <T extends Mojo> T lookupEmptyMojo(String goal, File pom) throws Exception {
        return this.testCase.lookupEmptyMojo(goal, pom);
    }

    public <T extends Mojo> T lookupMojo(String groupId, String artifactId, String version, String goal, PlexusConfiguration pluginConfiguration) throws Exception {
        return this.testCase.lookupMojo(groupId, artifactId, version, goal, pluginConfiguration);
    }

    public <T extends Mojo> T lookupConfiguredMojo(MavenProject project, String goal) throws Exception {
        return this.testCase.lookupConfiguredMojo(project, goal);
    }

    public <T extends Mojo> T lookupConfiguredMojo(MavenSession session, MojoExecution execution) throws Exception, ComponentConfigurationException {
        return this.testCase.lookupConfiguredMojo(session, execution);
    }

    public MavenSession newMavenSession(MavenProject project) {
        return this.testCase.newMavenSession(project);
    }

    public MojoExecution newMojoExecution(String goal) {
        return this.testCase.newMojoExecution(goal);
    }

    public PlexusConfiguration extractPluginConfiguration(String artifactId, File pom) throws Exception {
        return this.testCase.extractPluginConfiguration(artifactId, pom);
    }

    public PlexusConfiguration extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        return this.testCase.extractPluginConfiguration(artifactId, pomDom);
    }

    public <T extends Mojo> T configureMojo(T mojo, String artifactId, File pom) throws Exception {
        return this.testCase.configureMojo(mojo, artifactId, pom);
    }

    public <T extends Mojo> T configureMojo(T mojo, PlexusConfiguration pluginConfiguration) throws Exception {
        return this.testCase.configureMojo(mojo, pluginConfiguration);
    }

    public <T> T getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        return this.testCase.getVariableValueFromObject(object, variable);
    }

    public Map<String, Object> getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return this.testCase.getVariablesAndValuesFromObject(object);
    }

    public Map<String, Object> getVariablesAndValuesFromObject(Class<?> clazz, Object object) throws IllegalAccessException {
        return this.testCase.getVariablesAndValuesFromObject(clazz, object);
    }

    public <T> void setVariableValueToObject(Object object, String variable, T value) throws IllegalAccessException {
        this.testCase.setVariableValueToObject(object, variable, value);
    }

    public Statement apply(final Statement base, Description description) {
        if (description.getAnnotation(WithoutMojo.class) != null) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                MojoRule.this.testCase.setUp();
                MojoRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    MojoRule.this.after();
                }
            }
        };
    }

    public MavenProject readMavenProject(File basedir) throws Exception {
        File pom = new File(basedir, "pom.xml");
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setBaseDirectory(basedir);
        ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
        configuration.setRepositorySession((RepositorySystemSession)new DefaultRepositorySystemSession());
        MavenProject project = this.lookup(ProjectBuilder.class).build(pom, configuration).getProject();
        Assert.assertNotNull((Object)project);
        return project;
    }

    public void executeMojo(File basedir, String goal) throws Exception {
        MavenProject project = this.readMavenProject(basedir);
        MavenSession session = this.newMavenSession(project);
        MojoExecution execution = this.newMojoExecution(goal);
        this.executeMojo(session, project, execution);
    }

    public <T extends Mojo> T lookupConfiguredMojo(File basedir, String goal) throws Exception, ComponentConfigurationException {
        MavenProject project = this.readMavenProject(basedir);
        MavenSession session = this.newMavenSession(project);
        MojoExecution execution = this.newMojoExecution(goal);
        return this.lookupConfiguredMojo(session, execution);
    }

    public final <T> T lookup(Class<T> role) throws ComponentLookupException {
        return (T)this.getContainer().lookup(role);
    }

    public void executeMojo(MavenProject project, String goal, Xpp3Dom ... parameters) throws Exception {
        MavenSession session = this.newMavenSession(project);
        this.executeMojo(session, project, goal, parameters);
    }

    public void executeMojo(MavenSession session, MavenProject project, String goal, Xpp3Dom ... parameters) throws Exception {
        MojoExecution execution = this.newMojoExecution(goal);
        if (parameters != null) {
            Xpp3Dom configuration = execution.getConfiguration();
            for (Xpp3Dom parameter : parameters) {
                configuration.addChild(parameter);
            }
        }
        this.executeMojo(session, project, execution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        SessionScope sessionScope = this.lookup(SessionScope.class);
        try {
            sessionScope.enter();
            sessionScope.seed(MavenSession.class, (Object)session);
            MojoExecutionScope executionScope = this.lookup(MojoExecutionScope.class);
            try {
                executionScope.enter();
                executionScope.seed(MavenProject.class, (Object)project);
                executionScope.seed(MojoExecution.class, (Object)execution);
                Object mojo = this.lookupConfiguredMojo(session, execution);
                mojo.execute();
                MojoExecutionEvent event = new MojoExecutionEvent(session, project, execution, mojo);
                for (MojoExecutionListener listener : this.getContainer().lookupList(MojoExecutionListener.class)) {
                    listener.afterMojoExecutionSuccess(event);
                }
            }
            finally {
                executionScope.exit();
            }
        }
        finally {
            sessionScope.exit();
        }
    }
}

