/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         Modifications to the build process which is keyed on
 * some
 *         sort of environmental parameter.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Profile extends IdentifiableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field activation
     */
    private Activation activation;

    /**
     * Field properties
     */
    private java.util.Properties properties;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * 
     *             
     *             This may be removed or relocated in the near
     *             future. It is undecided whether plugins really
     * need a remote
     *             repository set of their own.
     *             
     *           
     */
    private java.util.List pluginRepositories;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPluginRepository
     * 
     * @param repository
     */
    public void addPluginRepository(Repository repository)
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Profile.addPluginRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getPluginRepositories().add( repository );
    } //-- void addPluginRepository(Repository) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Profile.addRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Get 
     *             
     *             The conditional logic which will automatically
     *             trigger the inclusion of this profile.
     *             
     *           
     */
    public Activation getActivation()
    {
        return this.activation;
    } //-- Activation getActivation() 

    /**
     * Method getPluginRepositories
     */
    public java.util.List getPluginRepositories()
    {
        if ( this.pluginRepositories == null )
        {
            this.pluginRepositories = new java.util.ArrayList();
        }
        
        return this.pluginRepositories;
    } //-- java.util.List getPluginRepositories() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method removePluginRepository
     * 
     * @param repository
     */
    public void removePluginRepository(Repository repository)
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Profile.removePluginRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getPluginRepositories().remove( repository );
    } //-- void removePluginRepository(Repository) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Profile.removeRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Set 
     *             
     *             The conditional logic which will automatically
     *             trigger the inclusion of this profile.
     *             
     *           
     * 
     * @param activation
     */
    public void setActivation(Activation activation)
    {
        this.activation = activation;
    } //-- void setActivation(Activation) 

    /**
     * Set 
     *             
     *             The lists of the remote repositories for
     * discovering plugins.
     *             
     *           
     * 
     * @param pluginRepositories
     */
    public void setPluginRepositories(java.util.List pluginRepositories)
    {
        this.pluginRepositories = pluginRepositories;
    } //-- void setPluginRepositories(java.util.List) 

    /**
     * Set 
     *             Extended configuration specific to this profile
     * goes here.
     *             Contents take the form of
     *             <property.name>property.value</property.name>
     *           
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Set 
     *             
     *             The lists of the remote repositories.
     *             
     *           
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
