/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.TrackableBase;

public class Settings
extends TrackableBase
implements Serializable {
    private String localRepository;
    private boolean interactiveMode = true;
    private boolean usePluginRegistry = true;
    private boolean offline = false;
    private List proxies;
    private List servers;
    private List mirrors;
    private List profiles;
    private List activeProfiles;
    private List pluginGroups;
    private Proxy activeProxy;
    private Map profileMap;
    private RuntimeInfo runtimeInfo;

    public void addActiveProfile(String string) {
        this.getActiveProfiles().add(string);
    }

    public void addMirror(Mirror mirror) {
        this.getMirrors().add(mirror);
    }

    public void addPluginGroup(String string) {
        this.getPluginGroups().add(string);
    }

    public void addProfile(Profile profile) {
        this.getProfiles().add(profile);
    }

    public void addProxy(Proxy proxy) {
        this.getProxies().add(proxy);
    }

    public void addServer(Server server) {
        this.getServers().add(server);
    }

    public List getActiveProfiles() {
        if (this.activeProfiles == null) {
            this.activeProfiles = new ArrayList();
        }
        return this.activeProfiles;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public List getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        return this.mirrors;
    }

    public List getPluginGroups() {
        if (this.pluginGroups == null) {
            this.pluginGroups = new ArrayList();
        }
        return this.pluginGroups;
    }

    public List getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList();
        }
        return this.profiles;
    }

    public List getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList();
        }
        return this.proxies;
    }

    public List getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        return this.servers;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void removeActiveProfile(String string) {
        this.getActiveProfiles().remove(string);
    }

    public void removeMirror(Mirror mirror) {
        this.getMirrors().remove(mirror);
    }

    public void removePluginGroup(String string) {
        this.getPluginGroups().remove(string);
    }

    public void removeProfile(Profile profile) {
        this.getProfiles().remove(profile);
    }

    public void removeProxy(Proxy proxy) {
        this.getProxies().remove(proxy);
    }

    public void removeServer(Server server) {
        this.getServers().remove(server);
    }

    public void setActiveProfiles(List activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public void setMirrors(List mirrors) {
        this.mirrors = mirrors;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setPluginGroups(List pluginGroups) {
        this.pluginGroups = pluginGroups;
    }

    public void setProfiles(List profiles) {
        this.profiles = profiles;
    }

    public void setProxies(List proxies) {
        this.proxies = proxies;
    }

    public void setServers(List servers) {
        this.servers = servers;
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.usePluginRegistry = usePluginRegistry;
    }

    public Boolean getInteractiveMode() {
        return this.isInteractiveMode();
    }

    public void flushActiveProxy() {
        this.activeProxy = null;
    }

    public synchronized Proxy getActiveProxy() {
        List proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            if (proxies.size() > 1) {
                Iterator it = proxies.iterator();
                while (it.hasNext()) {
                    Proxy proxy = (Proxy)it.next();
                    if (!proxy.isActive()) continue;
                    this.activeProxy = proxy;
                    break;
                }
            } else {
                this.activeProxy = (Proxy)proxies.get(0);
            }
        }
        return this.activeProxy;
    }

    public Server getServer(String serverId) {
        Server match = null;
        List servers = this.getServers();
        if (servers != null && serverId != null) {
            Iterator it = servers.iterator();
            while (it.hasNext()) {
                Server server = (Server)it.next();
                if (!serverId.equals(server.getId())) continue;
                match = server;
                break;
            }
        }
        return match;
    }

    public Mirror getMirrorOf(String repositoryId) {
        Mirror match = null;
        List mirrors = this.getMirrors();
        if (mirrors != null && repositoryId != null) {
            Iterator it = mirrors.iterator();
            while (it.hasNext()) {
                Mirror mirror = (Mirror)it.next();
                if (!repositoryId.equals(mirror.getMirrorOf())) continue;
                match = mirror;
                break;
            }
        }
        return match;
    }

    public void flushProfileMap() {
        this.profileMap = null;
    }

    public Map getProfilesAsMap() {
        if (this.profileMap == null) {
            this.profileMap = new HashMap();
            if (this.getProfiles() != null) {
                Iterator it = this.getProfiles().iterator();
                while (it.hasNext()) {
                    Profile profile = (Profile)it.next();
                    this.profileMap.put(profile.getId(), profile);
                }
            }
        }
        return this.profileMap;
    }

    public void setRuntimeInfo(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }
}

