/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;

public class Settings
implements Serializable {
    private List proxies;
    private List servers;
    private List mirrors;
    private List profiles;
    private Profile activeProfile;
    private Proxy activeProxy;

    public void addMirror(Mirror mirror) {
        this.getMirrors().add(mirror);
    }

    public void addProfile(Profile profile) {
        this.getProfiles().add(profile);
    }

    public void addProxy(Proxy proxy) {
        this.getProxies().add(proxy);
    }

    public void addServer(Server server) {
        this.getServers().add(server);
    }

    public List getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        return this.mirrors;
    }

    public List getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList();
        }
        return this.profiles;
    }

    public List getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList();
        }
        return this.proxies;
    }

    public List getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        return this.servers;
    }

    public void removeMirror(Mirror mirror) {
        this.getMirrors().remove(mirror);
    }

    public void removeProfile(Profile profile) {
        this.getProfiles().remove(profile);
    }

    public void removeProxy(Proxy proxy) {
        this.getProxies().remove(proxy);
    }

    public void removeServer(Server server) {
        this.getServers().remove(server);
    }

    public void setMirrors(List mirrors) {
        this.mirrors = mirrors;
    }

    public void setProfiles(List profiles) {
        this.profiles = profiles;
    }

    public void setProxies(List proxies) {
        this.proxies = proxies;
    }

    public void setServers(List servers) {
        this.servers = servers;
    }

    public synchronized void initializeActiveProfile(String localRepository) {
        if (this.getActiveProfile() == null) {
            Profile profile = new Profile();
            profile.setLocalRepository(localRepository);
            profile.setActive(true);
            this.addProfile(profile);
            this.activeProfile = profile;
        }
    }

    public synchronized Profile getActiveProfile() {
        List profiles;
        if (this.activeProfile == null && (profiles = this.getProfiles()) != null && !profiles.isEmpty()) {
            if (profiles.size() > 1) {
                Iterator it = profiles.iterator();
                while (it.hasNext()) {
                    Profile profile = (Profile)it.next();
                    if (!profile.isActive()) continue;
                    this.activeProfile = profile;
                    break;
                }
            } else {
                this.activeProfile = (Profile)profiles.get(0);
            }
        }
        return this.activeProfile;
    }

    public synchronized Proxy getActiveProxy() {
        List proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            if (proxies.size() > 1) {
                Iterator it = proxies.iterator();
                while (it.hasNext()) {
                    Proxy proxy = (Proxy)it.next();
                    if (!proxy.isActive()) continue;
                    this.activeProxy = proxy;
                    break;
                }
            } else {
                this.activeProxy = (Proxy)proxies.get(0);
            }
        }
        return this.activeProxy;
    }

    public Server getServer(String serverId) {
        Server match = null;
        List servers = this.getServers();
        if (servers != null && serverId != null) {
            Iterator it = servers.iterator();
            while (it.hasNext()) {
                Server server = (Server)it.next();
                if (!serverId.equals(server.getId())) continue;
                match = server;
                break;
            }
        }
        return match;
    }
}

