/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.xpp3;

import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.settings.Jdk;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SettingsXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, Settings settings) throws Exception {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.writeSettings(settings, "settings", this.serializer);
    }

    private void writeJdk(Jdk jdk, String tagName, XmlSerializer serializer) throws Exception {
        if (jdk != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (jdk.isActive()) {
                serializer.startTag(this.NAMESPACE, "active").text(String.valueOf(jdk.isActive())).endTag(this.NAMESPACE, "active");
            }
            if (jdk.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(jdk.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (jdk.getJavaHome() != null) {
                serializer.startTag(this.NAMESPACE, "javaHome").text(jdk.getJavaHome()).endTag(this.NAMESPACE, "javaHome");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws Exception {
        if (profile != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (profile.isActive()) {
                serializer.startTag(this.NAMESPACE, "active").text(String.valueOf(profile.isActive())).endTag(this.NAMESPACE, "active");
            }
            if (profile.getLocalRepository() != null) {
                serializer.startTag(this.NAMESPACE, "localRepository").text(profile.getLocalRepository()).endTag(this.NAMESPACE, "localRepository");
            }
            if (profile.getPasswordStore() != null) {
                serializer.startTag(this.NAMESPACE, "passwordStore").text(profile.getPasswordStore()).endTag(this.NAMESPACE, "passwordStore");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProxy(Proxy proxy, String tagName, XmlSerializer serializer) throws Exception {
        if (proxy != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (proxy.isActive()) {
                serializer.startTag(this.NAMESPACE, "active").text(String.valueOf(proxy.isActive())).endTag(this.NAMESPACE, "active");
            }
            if (proxy.getProtocol() != null) {
                serializer.startTag(this.NAMESPACE, "protocol").text(proxy.getProtocol()).endTag(this.NAMESPACE, "protocol");
            }
            if (proxy.getUsername() != null) {
                serializer.startTag(this.NAMESPACE, "username").text(proxy.getUsername()).endTag(this.NAMESPACE, "username");
            }
            if (proxy.getPassword() != null) {
                serializer.startTag(this.NAMESPACE, "password").text(proxy.getPassword()).endTag(this.NAMESPACE, "password");
            }
            if (proxy.getPort() != 0) {
                serializer.startTag(this.NAMESPACE, "port").text(String.valueOf(proxy.getPort())).endTag(this.NAMESPACE, "port");
            }
            if (proxy.getHost() != null) {
                serializer.startTag(this.NAMESPACE, "host").text(proxy.getHost()).endTag(this.NAMESPACE, "host");
            }
            if (proxy.getNonProxyHosts() != null) {
                serializer.startTag(this.NAMESPACE, "nonProxyHosts").text(proxy.getNonProxyHosts()).endTag(this.NAMESPACE, "nonProxyHosts");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeServer(Server server, String tagName, XmlSerializer serializer) throws Exception {
        if (server != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (server.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(server.getId()).endTag(this.NAMESPACE, "id");
            }
            if (server.getUsername() != null) {
                serializer.startTag(this.NAMESPACE, "username").text(server.getUsername()).endTag(this.NAMESPACE, "username");
            }
            if (server.getPassword() != null) {
                serializer.startTag(this.NAMESPACE, "password").text(server.getPassword()).endTag(this.NAMESPACE, "password");
            }
            if (server.getPrivateKey() != null) {
                serializer.startTag(this.NAMESPACE, "privateKey").text(server.getPrivateKey()).endTag(this.NAMESPACE, "privateKey");
            }
            if (server.getPassphrase() != null) {
                serializer.startTag(this.NAMESPACE, "passphrase").text(server.getPassphrase()).endTag(this.NAMESPACE, "passphrase");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSettings(Settings settings, String tagName, XmlSerializer serializer) throws Exception {
        if (settings != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (settings.getJdks() != null && settings.getJdks().size() > 0) {
                serializer.startTag(this.NAMESPACE, "jdks");
                iter = settings.getJdks().iterator();
                while (iter.hasNext()) {
                    Jdk jdk = (Jdk)iter.next();
                    this.writeJdk(jdk, "jdk", serializer);
                }
                serializer.endTag(this.NAMESPACE, "jdks");
            }
            if (settings.getProxies() != null && settings.getProxies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "proxies");
                iter = settings.getProxies().iterator();
                while (iter.hasNext()) {
                    Proxy proxy = (Proxy)iter.next();
                    this.writeProxy(proxy, "proxy", serializer);
                }
                serializer.endTag(this.NAMESPACE, "proxies");
            }
            if (settings.getServers() != null && settings.getServers().size() > 0) {
                serializer.startTag(this.NAMESPACE, "servers");
                iter = settings.getServers().iterator();
                while (iter.hasNext()) {
                    Server server = (Server)iter.next();
                    this.writeServer(server, "server", serializer);
                }
                serializer.endTag(this.NAMESPACE, "servers");
            }
            if (settings.getProfiles() != null && settings.getProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "profiles");
                iter = settings.getProfiles().iterator();
                while (iter.hasNext()) {
                    Profile profile = (Profile)iter.next();
                    this.writeProfile(profile, "profile", serializer);
                }
                serializer.endTag(this.NAMESPACE, "profiles");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

