/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.v4.SettingsStaxWriter;

@Named
@Singleton
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(File output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings, "settings cannot be null");
        output.getParentFile().mkdirs();
        this.write(Files.newOutputStream(output.toPath(), new OpenOption[0]), options, settings);
    }

    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings, "settings cannot be null");
        try (Writer out = output;){
            new SettingsStaxWriter().write(out, settings.getDelegate());
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing settings", e);
        }
    }

    @Override
    public void write(OutputStream output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(settings, "settings cannot be null");
        try (OutputStream out = output;){
            new SettingsStaxWriter().write(out, settings.getDelegate());
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing settings", e);
        }
    }
}

