/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;

public class Metadata
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private Versioning versioning;
    private List plugins;

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        return this.plugins;
    }

    public String getVersion() {
        return this.version;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public void removePlugin(Plugin plugin) {
        this.getPlugins().remove(plugin);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPlugins(List plugins) {
        this.plugins = plugins;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersioning(Versioning versioning) {
        this.versioning = versioning;
    }

    public boolean merge(Metadata sourceMetadata) {
        boolean changed = false;
        Iterator i = sourceMetadata.getPlugins().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            boolean found = false;
            Iterator it = this.getPlugins().iterator();
            while (it.hasNext() && !found) {
                Plugin preExisting = (Plugin)it.next();
                if (!preExisting.getPrefix().equals(plugin.getPrefix())) continue;
                found = true;
            }
            if (found) continue;
            Plugin mappedPlugin = new Plugin();
            mappedPlugin.setArtifactId(plugin.getArtifactId());
            mappedPlugin.setPrefix(plugin.getPrefix());
            this.addPlugin(mappedPlugin);
            changed = true;
        }
        Versioning versioning = sourceMetadata.getVersioning();
        if (versioning != null) {
            Versioning v = this.getVersioning();
            if (v != null) {
                if (versioning.getRelease() != null) {
                    changed = true;
                    v.setRelease(versioning.getRelease());
                }
                if (versioning.getLatest() != null) {
                    changed = true;
                    v.setLatest(versioning.getLatest());
                }
                Iterator i2 = versioning.getVersions().iterator();
                while (i2.hasNext()) {
                    String version = (String)i2.next();
                    if (v.getVersions().contains(version)) continue;
                    changed = true;
                    v.getVersions().add(version);
                }
                Snapshot s = v.getSnapshot();
                Snapshot snapshot = versioning.getSnapshot();
                if (snapshot != null) {
                    if (s == null) {
                        v.setSnapshot(snapshot);
                        changed = true;
                    } else if (snapshot.isLocalCopy()) {
                        s.setLocalCopy(true);
                        s.setTimestamp(null);
                        s.setBuildNumber(0);
                        changed = true;
                    } else {
                        if (snapshot.getTimestamp() != null && !snapshot.getTimestamp().equals(s.getTimestamp())) {
                            s.setTimestamp(snapshot.getTimestamp());
                            changed = true;
                        }
                        if (snapshot.getBuildNumber() > 0 && s.getBuildNumber() != snapshot.getBuildNumber()) {
                            s.setBuildNumber(snapshot.getBuildNumber());
                            changed = true;
                        }
                        if (s.isLocalCopy()) {
                            s.setLocalCopy(false);
                            changed = true;
                        }
                    }
                }
            } else {
                this.setVersioning(versioning);
                changed = true;
            }
        }
        return changed;
    }
}

