/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class ReportSet.
 * 
 * @version $Revision$ $Date$
 */
public class ReportSet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field configuration
     */
    private Object configuration;

    /**
     * Field inherited
     */
    private String inherited;

    /**
     * Field reports
     */
    private java.util.List reports;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addReport
     * 
     * @param string
     */
    public void addReport(String string)
    {
        getReports().add( string );
    } //-- void addReport(String) 

    /**
     * Method getConfiguration
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Method getId
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getInherited
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited() 

    /**
     * Method getReports
     */
    public java.util.List getReports()
    {
        if ( this.reports == null )
        {
            this.reports = new java.util.ArrayList();
        }
        
        return this.reports;
    } //-- java.util.List getReports() 

    /**
     * Method removeReport
     * 
     * @param string
     */
    public void removeReport(String string)
    {
        getReports().remove( string );
    } //-- void removeReport(String) 

    /**
     * Method setConfiguration
     * 
     * @param configuration
     */
    public void setConfiguration(Object configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(Object) 

    /**
     * Method setId
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Method setInherited
     * 
     * @param inherited
     */
    public void setInherited(String inherited)
    {
        this.inherited = inherited;
    } //-- void setInherited(String) 

    /**
     * Method setReports
     * 
     * @param reports
     */
    public void setReports(java.util.List reports)
    {
        this.reports = reports;
    } //-- void setReports(java.util.List) 


    private boolean inheritanceApplied = true;
    
    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }
    
    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }
          }
