/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Build.
 * 
 * @version $Revision$ $Date$
 */
public class Build extends BuildBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field sourceDirectory
     */
    private String sourceDirectory;

    /**
     * Field scriptSourceDirectory
     */
    private String scriptSourceDirectory;

    /**
     * Field testSourceDirectory
     */
    private String testSourceDirectory;

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field testOutputDirectory
     */
    private String testOutputDirectory;

    /**
     * Field extensions
     */
    private java.util.List extensions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExtension
     * 
     * @param extension
     */
    public void addExtension(Extension extension)
    {
        getExtensions().add( extension );
    } //-- void addExtension(Extension) 

    /**
     * Method getExtensions
     */
    public java.util.List getExtensions()
    {
        if ( this.extensions == null )
        {
            this.extensions = new java.util.ArrayList();
        }
        
        return this.extensions;
    } //-- java.util.List getExtensions() 

    /**
     * Method getOutputDirectory
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Method getScriptSourceDirectory
     */
    public String getScriptSourceDirectory()
    {
        return this.scriptSourceDirectory;
    } //-- String getScriptSourceDirectory() 

    /**
     * Method getSourceDirectory
     */
    public String getSourceDirectory()
    {
        return this.sourceDirectory;
    } //-- String getSourceDirectory() 

    /**
     * Method getTestOutputDirectory
     */
    public String getTestOutputDirectory()
    {
        return this.testOutputDirectory;
    } //-- String getTestOutputDirectory() 

    /**
     * Method getTestSourceDirectory
     */
    public String getTestSourceDirectory()
    {
        return this.testSourceDirectory;
    } //-- String getTestSourceDirectory() 

    /**
     * Method removeExtension
     * 
     * @param extension
     */
    public void removeExtension(Extension extension)
    {
        getExtensions().remove( extension );
    } //-- void removeExtension(Extension) 

    /**
     * Method setExtensions
     * 
     * @param extensions
     */
    public void setExtensions(java.util.List extensions)
    {
        this.extensions = extensions;
    } //-- void setExtensions(java.util.List) 

    /**
     * Method setOutputDirectory
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

    /**
     * Method setScriptSourceDirectory
     * 
     * @param scriptSourceDirectory
     */
    public void setScriptSourceDirectory(String scriptSourceDirectory)
    {
        this.scriptSourceDirectory = scriptSourceDirectory;
    } //-- void setScriptSourceDirectory(String) 

    /**
     * Method setSourceDirectory
     * 
     * @param sourceDirectory
     */
    public void setSourceDirectory(String sourceDirectory)
    {
        this.sourceDirectory = sourceDirectory;
    } //-- void setSourceDirectory(String) 

    /**
     * Method setTestOutputDirectory
     * 
     * @param testOutputDirectory
     */
    public void setTestOutputDirectory(String testOutputDirectory)
    {
        this.testOutputDirectory = testOutputDirectory;
    } //-- void setTestOutputDirectory(String) 

    /**
     * Method setTestSourceDirectory
     * 
     * @param testSourceDirectory
     */
    public void setTestSourceDirectory(String testSourceDirectory)
    {
        this.testSourceDirectory = testSourceDirectory;
    } //-- void setTestSourceDirectory(String) 

}
