/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         The <code>&lt;execution&gt;</code> element contains
 * informations required for the
 *         execution of a plugin.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class PluginExecution extends ConfigurationContainer 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id = "default";

    /**
     * Field phase
     */
    private String phase;

    /**
     * Field goals
     */
    private java.util.List goals;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addGoal
     * 
     * @param string
     */
    public void addGoal(String string)
    {
        getGoals().add( string );
    } //-- void addGoal(String) 

    /**
     * Method getGoals
     */
    public java.util.List getGoals()
    {
        if ( this.goals == null )
        {
            this.goals = new java.util.ArrayList();
        }
        
        return this.goals;
    } //-- java.util.List getGoals() 

    /**
     * Get 
     *             The identifier of this execution for labelling
     * the goals
     *             during the build, and for matching executions to
     * merge during
     *             inheritance.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The build lifecycle phase to bind the goals in
     * this
     *             execution to. If omitted, the goals will be
     * bound to the
     *             default phase specified in their metadata.
     *           
     */
    public String getPhase()
    {
        return this.phase;
    } //-- String getPhase() 

    /**
     * Method removeGoal
     * 
     * @param string
     */
    public void removeGoal(String string)
    {
        getGoals().remove( string );
    } //-- void removeGoal(String) 

    /**
     * Set 
     *             The goals to execute with the given
     * configuration.
     *           
     * 
     * @param goals
     */
    public void setGoals(java.util.List goals)
    {
        this.goals = goals;
    } //-- void setGoals(java.util.List) 

    /**
     * Set 
     *             The identifier of this execution for labelling
     * the goals
     *             during the build, and for matching executions to
     * merge during
     *             inheritance.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The build lifecycle phase to bind the goals in
     * this
     *             execution to. If omitted, the goals will be
     * bound to the
     *             default phase specified in their metadata.
     *           
     * 
     * @param phase
     */
    public void setPhase(String phase)
    {
        this.phase = phase;
    } //-- void setPhase(String) 


            
    public static final String DEFAULT_EXECUTION_ID = "default";
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
