/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         Base class for the <code>Model</code> and the
 * <code>Profile</code> objects.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ModelBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field modules
     */
    private java.util.List modules;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * Field pluginRepositories
     */
    private java.util.List pluginRepositories;

    /**
     * Field dependencies
     */
    private java.util.List dependencies;

    /**
     * Field reports
     */
    private Object reports;

    /**
     * Field reporting
     */
    private Reporting reporting;

    /**
     * Field dependencyManagement
     */
    private DependencyManagement dependencyManagement;

    /**
     * Field distributionManagement
     */
    private DistributionManagement distributionManagement;

    /**
     * Field properties
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency
     * 
     * @param dependency
     */
    public void addDependency(Dependency dependency)
    {
        getDependencies().add( dependency );
    } //-- void addDependency(Dependency) 

    /**
     * Method addModule
     * 
     * @param string
     */
    public void addModule(String string)
    {
        getModules().add( string );
    } //-- void addModule(String) 

    /**
     * Method addPluginRepository
     * 
     * @param repository
     */
    public void addPluginRepository(Repository repository)
    {
        getPluginRepositories().add( repository );
    } //-- void addPluginRepository(Repository) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Method getDependencies
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Get 
     *             
     *             Default dependency information for projects that
     * inherit from
     *             this one. The dependencies in this section are
     * not immediately resolved.
     *             Instead, when a POM derived from this one
     * declares a dependency
     *             described by a matching groupId and artifactId,
     * the version and other values from this
     *             section are used for that dependency if they
     * were not already specified.
     *             
     *           
     */
    public DependencyManagement getDependencyManagement()
    {
        return this.dependencyManagement;
    } //-- DependencyManagement getDependencyManagement() 

    /**
     * Get 
     *             
     *             Distribution information for a project that
     * enables deployment of the site
     *             and artifacts to remote web servers and
     * repositories respectively.
     *             
     *           
     */
    public DistributionManagement getDistributionManagement()
    {
        return this.distributionManagement;
    } //-- DistributionManagement getDistributionManagement() 

    /**
     * Method getModules
     */
    public java.util.List getModules()
    {
        if ( this.modules == null )
        {
            this.modules = new java.util.ArrayList();
        }
        
        return this.modules;
    } //-- java.util.List getModules() 

    /**
     * Method getPluginRepositories
     */
    public java.util.List getPluginRepositories()
    {
        if ( this.pluginRepositories == null )
        {
            this.pluginRepositories = new java.util.ArrayList();
        }
        
        return this.pluginRepositories;
    } //-- java.util.List getPluginRepositories() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Get 
     *             
     *             This element includes the specification of
     * report plugins to use
     *             to generate the reports on the Maven-generated
     * site.
     *             These reports will be run when a user executes
     * <code>mvn site</code>.
     *             All of the reports will be included in the
     * navigation bar for browsing.
     *             
     *           
     */
    public Reporting getReporting()
    {
        return this.reporting;
    } //-- Reporting getReporting() 

    /**
     * Get 
     *             
     *             <b>Deprecated</b>. Now ignored by Maven.
     *             
     *           
     */
    public Object getReports()
    {
        return this.reports;
    } //-- Object getReports() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method removeDependency
     * 
     * @param dependency
     */
    public void removeDependency(Dependency dependency)
    {
        getDependencies().remove( dependency );
    } //-- void removeDependency(Dependency) 

    /**
     * Method removeModule
     * 
     * @param string
     */
    public void removeModule(String string)
    {
        getModules().remove( string );
    } //-- void removeModule(String) 

    /**
     * Method removePluginRepository
     * 
     * @param repository
     */
    public void removePluginRepository(Repository repository)
    {
        getPluginRepositories().remove( repository );
    } //-- void removePluginRepository(Repository) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Set 
     *             
     *             This element describes all of the dependencies
     * associated with a
     *             project.
     *             These dependencies are used to construct a
     * classpath for your
     *             project during the build process. They are
     * automatically downloaded from the
     *             repositories defined in this project.
     *             See <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a> for more information.
     *             
     *           
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 

    /**
     * Set 
     *             
     *             Default dependency information for projects that
     * inherit from
     *             this one. The dependencies in this section are
     * not immediately resolved.
     *             Instead, when a POM derived from this one
     * declares a dependency
     *             described by a matching groupId and artifactId,
     * the version and other values from this
     *             section are used for that dependency if they
     * were not already specified.
     *             
     *           
     * 
     * @param dependencyManagement
     */
    public void setDependencyManagement(DependencyManagement dependencyManagement)
    {
        this.dependencyManagement = dependencyManagement;
    } //-- void setDependencyManagement(DependencyManagement) 

    /**
     * Set 
     *             
     *             Distribution information for a project that
     * enables deployment of the site
     *             and artifacts to remote web servers and
     * repositories respectively.
     *             
     *           
     * 
     * @param distributionManagement
     */
    public void setDistributionManagement(DistributionManagement distributionManagement)
    {
        this.distributionManagement = distributionManagement;
    } //-- void setDistributionManagement(DistributionManagement) 

    /**
     * Set 
     *             The modules (sometimes called subprojects) to
     * build as a
     *             part of this project. Each module listed is a
     * relative path
     *             to the directory containing the module.
     *           
     * 
     * @param modules
     */
    public void setModules(java.util.List modules)
    {
        this.modules = modules;
    } //-- void setModules(java.util.List) 

    /**
     * Set 
     *             
     *             The lists of the remote repositories for
     * discovering plugins for builds and reports.
     *             
     *           
     * 
     * @param pluginRepositories
     */
    public void setPluginRepositories(java.util.List pluginRepositories)
    {
        this.pluginRepositories = pluginRepositories;
    } //-- void setPluginRepositories(java.util.List) 

    /**
     * Set 
     *             
     *             Properties that can be used throughout the POM
     * as a substitution, and
     *             are used as filters in resources if enabled.
     *             The format is
     * <code>&lt;name&gt;value&lt;/name&gt;</code>.
     *             
     *           
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Set 
     *             
     *             This element includes the specification of
     * report plugins to use
     *             to generate the reports on the Maven-generated
     * site.
     *             These reports will be run when a user executes
     * <code>mvn site</code>.
     *             All of the reports will be included in the
     * navigation bar for browsing.
     *             
     *           
     * 
     * @param reporting
     */
    public void setReporting(Reporting reporting)
    {
        this.reporting = reporting;
    } //-- void setReporting(Reporting) 

    /**
     * Set 
     *             
     *             <b>Deprecated</b>. Now ignored by Maven.
     *             
     *           
     * 
     * @param reports
     */
    public void setReports(Object reports)
    {
        this.reports = reports;
    } //-- void setReports(Object) 

    /**
     * Set 
     *             
     *             The lists of the remote repositories for
     * discovering dependencies and
     *             extensions.
     *             
     *           
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
