/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         The <code>&lt;dependency&gt;</code> element contains
 * informations required to a dependency
 *         of the project.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Dependency implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field type
     */
    private String type = "jar";

    /**
     * Field classifier
     */
    private String classifier;

    /**
     * Field scope
     */
    private String scope;

    /**
     * Field systemPath
     */
    private String systemPath;

    /**
     * Field exclusions
     */
    private java.util.List exclusions;

    /**
     * Field optional
     */
    private boolean optional = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclusion
     * 
     * @param exclusion
     */
    public void addExclusion(Exclusion exclusion)
    {
        getExclusions().add( exclusion );
    } //-- void addExclusion(Exclusion) 

    /**
     * Get 
     *             
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>maven-artifact</code>.
     *             
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts
     *             that belong to the same POM but were built
     * differently, and is appended to
     *             the filename after the version. For example,
     * <code>jdk14</code> and <code>jdk15</code>.
     *             
     *           
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier() 

    /**
     * Method getExclusions
     */
    public java.util.List getExclusions()
    {
        if ( this.exclusions == null )
        {
            this.exclusions = new java.util.ArrayList();
        }
        
        return this.exclusions;
    } //-- java.util.List getExclusions() 

    /**
     * Get 
     *             
     *             The project group that produced the dependency,
     * e.g.
     *             <code>org.apache.maven</code>.
     *             
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             
     *             The scope of the dependency -
     * <code>compile</code>, <code>runtime</code>,
     *             <code>test</code>, <code>system</code>, and
     * <code>provided</code>. Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on.
     *             It also assists in determining which artifacts
     * to include in a distribution of
     *             this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     *             
     *           
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Get 
     *             
     *             FOR SYSTEM SCOPE ONLY. Note that use of this
     * property is <b>discouraged</b>
     *             and may be replaced in later versions. This
     * specifies the path on the filesystem
     *             for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     *             
     *           
     */
    public String getSystemPath()
    {
        return this.systemPath;
    } //-- String getSystemPath() 

    /**
     * Get 
     *             
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it
     *             usually represents the extension on the filename
     * of the dependency,
     *             that is not always the case. A type can be
     * mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also
     *             not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code>
     *             and <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     *             
     *           
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get 
     *             
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>. In Maven 2, this can also be
     *             specified as a range of versions.
     *             
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get 
     *             Indicates the dependency is optional for use of
     * this
     *             library. While the version of the dependency
     * will be taken
     *             into account for dependency calculation if the
     * library is
     *             used elsewhere, it will not be passed on
     * transitively.
     *           
     */
    public boolean isOptional()
    {
        return this.optional;
    } //-- boolean isOptional() 

    /**
     * Method removeExclusion
     * 
     * @param exclusion
     */
    public void removeExclusion(Exclusion exclusion)
    {
        getExclusions().remove( exclusion );
    } //-- void removeExclusion(Exclusion) 

    /**
     * Set 
     *             
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>maven-artifact</code>.
     *             
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts
     *             that belong to the same POM but were built
     * differently, and is appended to
     *             the filename after the version. For example,
     * <code>jdk14</code> and <code>jdk15</code>.
     *             
     *           
     * 
     * @param classifier
     */
    public void setClassifier(String classifier)
    {
        this.classifier = classifier;
    } //-- void setClassifier(String) 

    /**
     * Set 
     *             Lists a set of artifacts that should be excluded
     * from this
     *             dependency's artifact list when it comes to
     * calculating
     *             transitive dependencies.
     *           
     * 
     * @param exclusions
     */
    public void setExclusions(java.util.List exclusions)
    {
        this.exclusions = exclusions;
    } //-- void setExclusions(java.util.List) 

    /**
     * Set 
     *             
     *             The project group that produced the dependency,
     * e.g.
     *             <code>org.apache.maven</code>.
     *             
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             Indicates the dependency is optional for use of
     * this
     *             library. While the version of the dependency
     * will be taken
     *             into account for dependency calculation if the
     * library is
     *             used elsewhere, it will not be passed on
     * transitively.
     *           
     * 
     * @param optional
     */
    public void setOptional(boolean optional)
    {
        this.optional = optional;
    } //-- void setOptional(boolean) 

    /**
     * Set 
     *             
     *             The scope of the dependency -
     * <code>compile</code>, <code>runtime</code>,
     *             <code>test</code>, <code>system</code>, and
     * <code>provided</code>. Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on.
     *             It also assists in determining which artifacts
     * to include in a distribution of
     *             this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     *             
     *           
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Set 
     *             
     *             FOR SYSTEM SCOPE ONLY. Note that use of this
     * property is <b>discouraged</b>
     *             and may be replaced in later versions. This
     * specifies the path on the filesystem
     *             for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     *             
     *           
     * 
     * @param systemPath
     */
    public void setSystemPath(String systemPath)
    {
        this.systemPath = systemPath;
    } //-- void setSystemPath(String) 

    /**
     * Set 
     *             
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it
     *             usually represents the extension on the filename
     * of the dependency,
     *             that is not always the case. A type can be
     * mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also
     *             not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code>
     *             and <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     *             
     *           
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set 
     *             
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>. In Maven 2, this can also be
     *             specified as a range of versions.
     *             
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Dependency {groupId=" + groupId + ", artifactId=" + artifactId + ", version=" + version + ", type=" + type + "}";
    }
            
          
            
    /**
     * @return the management key as <code>groupId:artifactId:type</code>
     */
    public String getManagementKey()
    {
        return groupId + ":" + artifactId + ":" + type + ( classifier != null ? ":" + classifier : "" );
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
