/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         Configures one method for notifying users/developers
 * when a build breaks.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Notifier implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field type
     */
    private String type = "mail";

    /**
     * Field sendOnError
     */
    private boolean sendOnError = true;

    /**
     * Field sendOnFailure
     */
    private boolean sendOnFailure = true;

    /**
     * Field sendOnSuccess
     */
    private boolean sendOnSuccess = true;

    /**
     * Field sendOnWarning
     */
    private boolean sendOnWarning = true;

    /**
     * Field address
     */
    private String address;

    /**
     * Field configuration
     */
    private java.util.Properties configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addConfiguration
     * 
     * @param key
     * @param value
     */
    public void addConfiguration(String key, String value)
    {
        getConfiguration().put( key, value );
    } //-- void addConfiguration(String, String) 

    /**
     * Get 
     *             <b>Deprecated</b>. Where to send the
     * notification to - eg email address.
     *           
     */
    public String getAddress()
    {
        return this.address;
    } //-- String getAddress() 

    /**
     * Method getConfiguration
     */
    public java.util.Properties getConfiguration()
    {
        if ( this.configuration == null )
        {
            this.configuration = new java.util.Properties();
        }
        
        return this.configuration;
    } //-- java.util.Properties getConfiguration() 

    /**
     * Get The mechanism used to deliver notifications.
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get Whether to send notifications on error.
     */
    public boolean isSendOnError()
    {
        return this.sendOnError;
    } //-- boolean isSendOnError() 

    /**
     * Get Whether to send notifications on failure.
     */
    public boolean isSendOnFailure()
    {
        return this.sendOnFailure;
    } //-- boolean isSendOnFailure() 

    /**
     * Get Whether to send notifications on success.
     */
    public boolean isSendOnSuccess()
    {
        return this.sendOnSuccess;
    } //-- boolean isSendOnSuccess() 

    /**
     * Get Whether to send notifications on warning.
     */
    public boolean isSendOnWarning()
    {
        return this.sendOnWarning;
    } //-- boolean isSendOnWarning() 

    /**
     * Set 
     *             <b>Deprecated</b>. Where to send the
     * notification to - eg email address.
     *           
     * 
     * @param address
     */
    public void setAddress(String address)
    {
        this.address = address;
    } //-- void setAddress(String) 

    /**
     * Set Extended configuration specific to this notifier goes
     * here.
     * 
     * @param configuration
     */
    public void setConfiguration(java.util.Properties configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(java.util.Properties) 

    /**
     * Set Whether to send notifications on error.
     * 
     * @param sendOnError
     */
    public void setSendOnError(boolean sendOnError)
    {
        this.sendOnError = sendOnError;
    } //-- void setSendOnError(boolean) 

    /**
     * Set Whether to send notifications on failure.
     * 
     * @param sendOnFailure
     */
    public void setSendOnFailure(boolean sendOnFailure)
    {
        this.sendOnFailure = sendOnFailure;
    } //-- void setSendOnFailure(boolean) 

    /**
     * Set Whether to send notifications on success.
     * 
     * @param sendOnSuccess
     */
    public void setSendOnSuccess(boolean sendOnSuccess)
    {
        this.sendOnSuccess = sendOnSuccess;
    } //-- void setSendOnSuccess(boolean) 

    /**
     * Set Whether to send notifications on warning.
     * 
     * @param sendOnWarning
     */
    public void setSendOnWarning(boolean sendOnWarning)
    {
        this.sendOnWarning = sendOnWarning;
    } //-- void setSendOnWarning(boolean) 

    /**
     * Set The mechanism used to deliver notifications.
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
