/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.io.ModelParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultModelProblemCollector
implements ModelProblemCollector {
    private List<ModelProblem> problems;
    private String source;
    private Model sourceModel;
    private Model rootModel;

    public DefaultModelProblemCollector(List<ModelProblem> problems) {
        this.problems = problems != null ? problems : new ArrayList();
    }

    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public void setSource(String source) {
        this.source = source;
        this.sourceModel = null;
    }

    public void setSource(Model source) {
        this.sourceModel = source;
        this.source = null;
    }

    private String getSource() {
        if (this.source == null && this.sourceModel != null) {
            this.source = ModelProblemUtils.toPath(this.sourceModel);
        }
        return this.source;
    }

    private String getModelId() {
        return ModelProblemUtils.toId(this.sourceModel);
    }

    public void setRootModel(Model rootModel) {
        this.rootModel = rootModel;
    }

    public Model getRootModel() {
        return this.rootModel;
    }

    public String getRootModelId() {
        return ModelProblemUtils.toId(this.rootModel);
    }

    public void add(ModelProblem problem) {
        this.problems.add(problem);
    }

    public void addAll(List<ModelProblem> problems) {
        problems.addAll(problems);
    }

    public void addFatalError(String message, Exception cause) {
        int line = -1;
        int column = -1;
        if (cause instanceof ModelParseException) {
            ModelParseException e = (ModelParseException)cause;
            line = e.getLineNumber();
            column = e.getColumnNumber();
        }
        this.add(message, ModelProblem.Severity.FATAL, line, column, cause);
    }

    @Override
    public void addError(String message) {
        this.addError(message, null);
    }

    @Override
    public void addError(String message, Exception cause) {
        int line = -1;
        int column = -1;
        if (cause instanceof ModelParseException) {
            ModelParseException e = (ModelParseException)cause;
            line = e.getLineNumber();
            column = e.getColumnNumber();
        }
        this.add(message, ModelProblem.Severity.ERROR, line, column, cause);
    }

    @Override
    public void addWarning(String message) {
        this.addWarning(message, null);
    }

    @Override
    public void addWarning(String message, Exception cause) {
        int line = -1;
        int column = -1;
        if (cause instanceof ModelParseException) {
            ModelParseException e = (ModelParseException)cause;
            line = e.getLineNumber();
            column = e.getColumnNumber();
        }
        this.add(message, ModelProblem.Severity.WARNING, line, column, cause);
    }

    private void add(String message, ModelProblem.Severity severity, int line, int column, Exception cause) {
        this.problems.add(new DefaultModelProblem(message, severity, this.getSource(), line, column, this.getModelId(), cause));
    }
}

