/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.internal.extension.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.ImmutableCollections;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CoreExtensions
implements Serializable {
    final String namespaceUri;
    final String modelEncoding;
    final List<CoreExtension> extensions;

    CoreExtensions(String namespaceUri, String modelEncoding, Collection<CoreExtension> extensions) {
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.extensions = ImmutableCollections.copy(extensions);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Nonnull
    public List<CoreExtension> getExtensions() {
        return this.extensions;
    }

    @Nonnull
    public Builder with() {
        return CoreExtensions.newBuilder(this);
    }

    @Nonnull
    public CoreExtensions withExtensions(Collection<CoreExtension> extensions) {
        return CoreExtensions.newBuilder(this, true).extensions(extensions).build();
    }

    @Nonnull
    public static CoreExtensions newInstance() {
        return CoreExtensions.newInstance(true);
    }

    @Nonnull
    public static CoreExtensions newInstance(boolean withDefaults) {
        return CoreExtensions.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CoreExtensions.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtensions from) {
        return CoreExtensions.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtensions from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        CoreExtensions base;
        String namespaceUri;
        String modelEncoding;
        Collection<CoreExtension> extensions;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(CoreExtensions base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.extensions = base.extensions;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<CoreExtension> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Nonnull
        public CoreExtensions build() {
            if (this.base != null && (this.extensions == null || this.extensions == this.base.extensions)) {
                return this.base;
            }
            return new CoreExtensions(this.namespaceUri != null ? this.namespaceUri : (this.base != null ? this.base.namespaceUri : ""), this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.extensions != null ? this.extensions : (this.base != null ? this.base.extensions : null));
        }
    }
}

