/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;

@Deprecated
public final class MetadataBridge
extends AbstractMetadata
implements MergeableMetadata {
    private ArtifactMetadata metadata;
    private boolean merged;

    public MetadataBridge(ArtifactMetadata metadata) {
        this.metadata = metadata;
    }

    public void merge(File current, File result) throws RepositoryException {
        try {
            if (current.exists()) {
                Files.createDirectories(result.toPath().getParent(), new FileAttribute[0]);
                Files.copy(current.toPath(), result.toPath(), new CopyOption[0]);
            }
            MetadataRepository localRepo = new MetadataRepository(result);
            this.metadata.storeInLocalRepository((ArtifactRepository)localRepo, (ArtifactRepository)localRepo);
            this.merged = true;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isMerged() {
        return this.merged;
    }

    public String getGroupId() {
        return this.emptify(this.metadata.getGroupId());
    }

    public String getArtifactId() {
        return this.metadata.storedInGroupDirectory() ? "" : this.emptify(this.metadata.getArtifactId());
    }

    public String getVersion() {
        return this.metadata.storedInArtifactVersionDirectory() ? this.emptify(this.metadata.getBaseVersion()) : "";
    }

    public String getType() {
        return this.metadata.getRemoteFilename();
    }

    private String emptify(String string) {
        return string != null ? string : "";
    }

    public File getFile() {
        return null;
    }

    public MetadataBridge setFile(File file) {
        return this;
    }

    public Metadata.Nature getNature() {
        if (this.metadata instanceof RepositoryMetadata) {
            switch (((RepositoryMetadata)this.metadata).getNature()) {
                case 3: {
                    return Metadata.Nature.RELEASE_OR_SNAPSHOT;
                }
                case 2: {
                    return Metadata.Nature.SNAPSHOT;
                }
            }
            return Metadata.Nature.RELEASE;
        }
        return Metadata.Nature.RELEASE;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public Metadata setProperties(Map<String, String> properties) {
        return this;
    }

    static class MetadataRepository
    extends DefaultArtifactRepository {
        private File metadataFile;

        MetadataRepository(File metadataFile) {
            super("local", "", null);
            this.metadataFile = metadataFile;
        }

        public String getBasedir() {
            return this.metadataFile.getParent();
        }

        @Override
        public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
            return this.metadataFile.getName();
        }
    }
}

