/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.ManifestSection;

public class MavenArchiveConfiguration {
    private boolean compress = true;
    private boolean recompressAddedZips = true;
    private boolean addMavenDescriptor = true;
    private Path manifestFile;
    private ManifestConfiguration manifest;
    private Map<String, String> manifestEntries = new LinkedHashMap<String, String>();
    private List<ManifestSection> manifestSections = new LinkedList<ManifestSection>();
    private boolean forced = true;
    private Path pomPropertiesFile;

    public boolean isCompress() {
        return this.compress;
    }

    public boolean isRecompressAddedZips() {
        return this.recompressAddedZips;
    }

    public void setRecompressAddedZips(boolean recompressAddedZips) {
        this.recompressAddedZips = recompressAddedZips;
    }

    public boolean isAddMavenDescriptor() {
        return this.addMavenDescriptor;
    }

    public Path getManifestFile() {
        return this.manifestFile;
    }

    public ManifestConfiguration getManifest() {
        if (this.manifest == null) {
            this.manifest = new ManifestConfiguration();
        }
        return this.manifest;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setAddMavenDescriptor(boolean addMavenDescriptor) {
        this.addMavenDescriptor = addMavenDescriptor;
    }

    public void setManifestFile(Path manifestFile) {
        this.manifestFile = manifestFile;
    }

    public void setManifest(ManifestConfiguration manifest) {
        this.manifest = manifest;
    }

    public void addManifestEntry(String key, String value) {
        this.manifestEntries.put(key, value);
    }

    public void addManifestEntries(Map<String, String> map) {
        this.manifestEntries.putAll(map);
    }

    public boolean isManifestEntriesEmpty() {
        return this.manifestEntries.isEmpty();
    }

    public Map<String, String> getManifestEntries() {
        return this.manifestEntries;
    }

    public void setManifestEntries(Map<String, String> manifestEntries) {
        this.manifestEntries = manifestEntries;
    }

    public void addManifestSection(ManifestSection section) {
        this.manifestSections.add(section);
    }

    public void addManifestSections(List<ManifestSection> list) {
        this.manifestSections.addAll(list);
    }

    public boolean isManifestSectionsEmpty() {
        return this.manifestSections.isEmpty();
    }

    public List<ManifestSection> getManifestSections() {
        return this.manifestSections;
    }

    public void setManifestSections(List<ManifestSection> manifestSections) {
        this.manifestSections = manifestSections;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public Path getPomPropertiesFile() {
        return this.pomPropertiesFile;
    }

    public void setPomPropertiesFile(Path pomPropertiesFile) {
        this.pomPropertiesFile = pomPropertiesFile;
    }
}

