/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.archiver.Archiver;

public class PomPropertiesUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(File file) throws IOException {
        Properties properties;
        Properties fileProps = new Properties();
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(file);
            fileProps.load(istream);
            ((InputStream)istream).close();
            istream = null;
            properties = fileProps;
        }
        catch (Throwable throwable) {
            IOUtil.close(istream);
            throw throwable;
        }
        IOUtil.close((InputStream)istream);
        return properties;
    }

    private boolean sameContents(Properties props, File file) throws IOException {
        if (!file.isFile()) {
            return false;
        }
        Properties fileProps = this.loadPropertiesFile(file);
        return fileProps.equals(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPropertiesFile(MavenSession session, Properties properties, File outputFile, boolean forceCreation) throws IOException {
        File outputDir = outputFile.getParentFile();
        if (outputDir != null && !outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new IOException("Failed to create directory: " + outputDir);
        }
        if (!forceCreation && this.sameContents(properties, outputFile)) {
            return;
        }
        PrintWriter pw = new PrintWriter(outputFile, "ISO-8859-1");
        try {
            String line;
            StringWriter sw = new StringWriter();
            properties.store(sw, null);
            BufferedReader r = new BufferedReader(new StringReader(sw.toString()));
            while ((line = r.readLine()) != null) {
                if (line.startsWith("#")) continue;
                pw.println(line);
            }
            r.close();
            r = null;
            sw.close();
            sw = null;
            pw.close();
            pw = null;
        }
        finally {
            IOUtil.close((Writer)pw);
        }
    }

    public void createPomProperties(MavenSession session, MavenProject project, Archiver archiver, File customPomPropertiesFile, File pomPropertiesFile, boolean forceCreation) throws IOException {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        Properties p = customPomPropertiesFile != null ? this.loadPropertiesFile(customPomPropertiesFile) : new Properties();
        p.setProperty("groupId", groupId);
        p.setProperty("artifactId", artifactId);
        p.setProperty("version", version);
        this.createPropertiesFile(session, p, pomPropertiesFile, forceCreation);
        archiver.addFile(pomPropertiesFile, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }
}

