/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.PatternSet;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class FileSet
extends PatternSet
implements Serializable,
InputLocationTracker {
    final String directory;

    FileSet(Collection<String> includes, Collection<String> excludes, String directory, Map<Object, InputLocation> locations) {
        super(includes, excludes, locations);
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    @Override
    @Nonnull
    public Builder with() {
        return FileSet.newBuilder(this);
    }

    @Override
    @Nonnull
    public FileSet withIncludes(Collection<String> includes) {
        return ((Builder)FileSet.newBuilder(this, true).includes((Collection)includes)).build();
    }

    @Override
    @Nonnull
    public FileSet withExcludes(Collection<String> excludes) {
        return ((Builder)FileSet.newBuilder(this, true).excludes((Collection)excludes)).build();
    }

    @Nonnull
    public FileSet withDirectory(String directory) {
        return FileSet.newBuilder(this, true).directory(directory).build();
    }

    @Nonnull
    public static FileSet newInstance() {
        return FileSet.newInstance(true);
    }

    @Nonnull
    public static FileSet newInstance(boolean withDefaults) {
        return FileSet.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return FileSet.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(FileSet from) {
        return FileSet.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(FileSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "FileSet {directory: " + this.getDirectory() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends PatternSet.Builder {
        FileSet base;
        String directory;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(FileSet base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.directory = base.directory;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Override
        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public FileSet build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes || this.directory != null && this.directory != this.base.directory)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("includes", newlocs.containsKey("includes") ? (InputLocation)newlocs.get("includes") : (InputLocation)oldlocs.get("includes"));
            locations.put("excludes", newlocs.containsKey("excludes") ? (InputLocation)newlocs.get("excludes") : (InputLocation)oldlocs.get("excludes"));
            locations.put("directory", newlocs.containsKey("directory") ? (InputLocation)newlocs.get("directory") : (InputLocation)oldlocs.get("directory"));
            return new FileSet(this.includes != null ? this.includes : (this.base != null ? this.base.includes : null), this.excludes != null ? this.excludes : (this.base != null ? this.base.excludes : null), this.directory != null ? this.directory : (this.base != null ? this.base.directory : null), locations);
        }
    }
}

