/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.services;

import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.mae.DefaultMAEExecutionRequest;
import org.apache.maven.mae.MAEExecutionRequest;
import org.apache.maven.mae.boot.embed.MAEEmbeddingException;
import org.apache.maven.mae.boot.services.MAEServiceManager;
import org.apache.maven.mae.boot.services.UnauthorizedServiceException;
import org.apache.maven.mae.internal.container.ServiceAuthorizer;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.sonatype.aether.RepositoryCache;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.util.DefaultRepositoryCache;

@Component(role=MAEServiceManager.class)
public class DefaultMAEServiceManager
implements MAEServiceManager {
    @Requirement
    private ProjectBuilder projectBuilder;
    @Requirement
    private org.apache.maven.repository.RepositorySystem repositorySystem;
    @Requirement
    private RepositorySystem aetherRepositorySystem;
    @Requirement
    private ServiceAuthorizer authorizer;
    @Requirement(role=Maven.class)
    private DefaultMaven defaultMaven;
    @Requirement
    private MavenExecutionRequestPopulator requestPopulator;
    private transient ArtifactRepository defaultLocalRepo;
    @Requirement
    private PlexusContainer container;

    @Override
    public ProjectBuilder projectBuilder() {
        return this.projectBuilder;
    }

    @Override
    public DefaultProjectBuildingRequest createProjectBuildingRequest() throws MAEEmbeddingException {
        return this.createProjectBuildingRequest((ProjectBuildingRequest)null);
    }

    @Override
    public DefaultProjectBuildingRequest createProjectBuildingRequest(MAEExecutionRequest executionRequest) throws MAEEmbeddingException {
        return this.createProjectBuildingRequest(executionRequest == null ? null : executionRequest.getProjectBuildingRequest());
    }

    @Override
    public DefaultProjectBuildingRequest createProjectBuildingRequest(MavenExecutionRequest executionRequest) throws MAEEmbeddingException {
        return this.createProjectBuildingRequest(executionRequest == null ? null : executionRequest.getProjectBuildingRequest());
    }

    @Override
    public DefaultProjectBuildingRequest createProjectBuildingRequest(ProjectBuildingRequest template) throws MAEEmbeddingException {
        DefaultProjectBuildingRequest req = template != null ? new DefaultProjectBuildingRequest(template) : new DefaultProjectBuildingRequest();
        if (req.getLocalRepository() == null) {
            req.setLocalRepository(this.defaultLocalRepository());
        }
        req.setValidationLevel(0);
        req.setProcessPlugins(false);
        req.setResolveDependencies(false);
        if (req.getRepositorySession() == null) {
            req.setRepositorySession(this.createAetherRepositorySystemSession());
        }
        return req;
    }

    @Override
    public org.apache.maven.repository.RepositorySystem mavenRepositorySystem() {
        return this.repositorySystem;
    }

    @Override
    public RepositorySystem aetherRepositorySystem() {
        return this.aetherRepositorySystem;
    }

    @Override
    public RepositorySystemSession createAetherRepositorySystemSession() throws MAEEmbeddingException {
        try {
            MavenExecutionRequest req = this.requestPopulator.populateDefaults(new DefaultMAEExecutionRequest().asMavenExecutionRequest());
            return this.defaultMaven.newRepositorySession(req);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new MAEEmbeddingException("Failed to populate default Maven execution request,  for use in constructing a repository system session.\nReason: %s", e, e.getMessage());
        }
    }

    @Override
    public RepositorySystemSession createAetherRepositorySystemSession(MavenExecutionRequest request) throws MAEEmbeddingException {
        if (request == null) {
            return this.createAetherRepositorySystemSession();
        }
        try {
            request = this.requestPopulator.populateDefaults(request);
            if (request.getRepositoryCache() == null) {
                request.setRepositoryCache((RepositoryCache)new DefaultRepositoryCache());
            }
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new MAEEmbeddingException("Failed to populate default Maven execution request,  for use in constructing a repository system session.\nReason: %s", e, e.getMessage());
        }
        return this.defaultMaven.newRepositorySession(request);
    }

    @Override
    public synchronized ArtifactRepository defaultLocalRepository() throws MAEEmbeddingException {
        if (this.defaultLocalRepo == null) {
            try {
                this.defaultLocalRepo = this.mavenRepositorySystem().createDefaultLocalRepository();
            }
            catch (InvalidRepositoryException e) {
                throw new MAEEmbeddingException("Failed to create default local-repository instance: {0}", e, e.getMessage());
            }
        }
        return this.defaultLocalRepo;
    }

    @Override
    public <T> T service(Class<T> type) throws MAEEmbeddingException {
        if (type == null) {
            throw new MAEEmbeddingException("Invalid service: null");
        }
        if (!this.authorizer.isAvailable(type)) {
            throw new UnauthorizedServiceException(type);
        }
        try {
            return type.cast(this.container.lookup(type));
        }
        catch (ComponentLookupException e) {
            throw new MAEEmbeddingException("Failed to retrieve service: %s. Reason: %s", e, type.getName(), e.getMessage());
        }
    }

    @Override
    public <T> T service(Class<T> type, String hint) throws MAEEmbeddingException {
        if (type == null) {
            throw new MAEEmbeddingException("Invalid service: null");
        }
        if (!this.authorizer.isAvailable(type, hint)) {
            throw new UnauthorizedServiceException(type, hint == null ? "" : hint);
        }
        try {
            return type.cast(this.container.lookup(type, hint));
        }
        catch (ComponentLookupException e) {
            throw new MAEEmbeddingException("Failed to retrieve service: %s with hint: %s. Reason: %s", e, type.getName(), hint, e.getMessage());
        }
    }
}

