/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.internal.LifecycleWeaveBuilder;
import org.apache.maven.mae.MAEExecutionRequest;
import org.apache.maven.mae.boot.embed.MAEEmbedder;
import org.apache.maven.mae.boot.embed.MAEEmbeddingException;
import org.apache.maven.mae.boot.log.BatchTransferListener;
import org.apache.maven.mae.boot.log.InteractiveTransferListener;
import org.apache.maven.mae.boot.main.CliRequest;
import org.apache.maven.mae.boot.main.MAECLIManager;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public class MAEMain {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";
    public static final String THREADS_DEPRECATED = "maven.threads.experimental";
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final File CONFIGURATION_DIRECTORY = userMavenConfigurationHome;
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(userMavenConfigurationHome, "toolchains.xml");
    private final ClassWorld classWorld;

    public MAEMain() {
        this(null);
    }

    public MAEMain(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public static void main(String[] args) {
        int result = MAEMain.main(args, null);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MAEMain cli = new MAEMain();
        return cli.doMain(new CliRequest(args, classWorld));
    }

    public static int doMain(String[] args, ClassWorld classWorld) {
        MAEMain cli = new MAEMain();
        return cli.doMain(new CliRequest(args, classWorld));
    }

    public int doMain(String[] args, String workingDirectory, PrintStream stdout, PrintStream stderr) {
        CliRequest cliRequest = new CliRequest(args, this.classWorld);
        cliRequest.workingDirectory = workingDirectory;
        cliRequest.builder.withStandardOut(stdout);
        cliRequest.builder.withStandardErr(stderr);
        return this.doMain(cliRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(CliRequest cliRequest) {
        try {
            this.initialize(cliRequest);
            this.cli(cliRequest);
            this.properties(cliRequest);
            this.settings(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            int n = e.exitCode;
            return n;
        }
        catch (Exception e) {
            CLIReportingUtils.showError((Logger)cliRequest.builder.logger(), (String)"Error executing Maven.", (Throwable)e, (boolean)cliRequest.builder.shouldShowErrors());
            int n = 1;
            return n;
        }
        finally {
            if (cliRequest.fileStream != null) {
                cliRequest.fileStream.close();
            }
        }
    }

    protected void initialize(CliRequest cliRequest) {
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
    }

    protected void cli(CliRequest cliRequest) throws Exception {
        MAECLIManager cliManager = new MAECLIManager();
        try {
            cliRequest.commandLine = cliManager.parse(cliRequest.args);
        }
        catch (ParseException e) {
            cliRequest.builder.standardErr().println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp(cliRequest.builder.standardOut());
            throw e;
        }
        cliRequest.builder.withErrorMode(cliRequest.commandLine.hasOption('e') || cliRequest.commandLine.hasOption('X'));
        cliRequest.builder.withDebugMode(cliRequest.commandLine.hasOption('X'));
        cliRequest.builder.withQuietMode(cliRequest.commandLine.hasOption('q'));
        cliRequest.builder.withVersion(cliRequest.commandLine.hasOption('V'));
        if (cliRequest.commandLine.hasOption("ZX")) {
            cliRequest.builder.withDebugLogHandles(cliRequest.commandLine.getOptionValue("ZX").split("\\s*,\\s*"));
        }
        if (cliRequest.commandLine.hasOption("l")) {
            cliRequest.builder.withLogFile(new File(cliRequest.commandLine.getOptionValue("l")));
        }
        if (cliRequest.commandLine.hasOption('h')) {
            cliManager.displayHelp(cliRequest.builder.standardOut());
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            try {
                MAEEmbedder.showVersion(cliRequest.builder.configuration(), cliRequest.builder.libraryLoaders(), cliRequest.builder.standardOut());
            }
            catch (IOException e) {
                cliRequest.builder.logger().error("Failed to retrieve EMB extension information: " + e.getMessage(), (Throwable)e);
            }
            throw new ExitException(0);
        }
    }

    protected void properties(CliRequest cliRequest) {
        this.populateProperties(cliRequest.commandLine, cliRequest.systemProperties, cliRequest.userProperties);
    }

    protected void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            String passwd = cliRequest.commandLine.getOptionValue("emp");
            cliRequest.request.setPasswordToEncrypt(passwd);
            cliRequest.builder.build().encryptMasterPassword(cliRequest.request);
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            String passwd = cliRequest.commandLine.getOptionValue("ep");
            cliRequest.request.setPasswordToEncrypt(passwd);
            cliRequest.builder.build().encryptPassword(cliRequest.request);
            throw new ExitException(0);
        }
    }

    protected int execute(CliRequest cliRequest) throws MAEEmbeddingException {
        MAEEmbedder embedder = cliRequest.builder.build();
        MavenExecutionResult result = embedder.execute(cliRequest.request);
        return embedder.formatErrorOutput(cliRequest.request, result);
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    protected void settings(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        if (cliRequest.commandLine.hasOption('s')) {
            userSettingsFile = new File(cliRequest.commandLine.getOptionValue('s'));
            if (!(userSettingsFile = this.resolveFile(userSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        cliRequest.request.setUserSettingsFile(userSettingsFile);
        cliRequest.builder.logger().debug("Reading user settings from " + userSettingsFile);
        if (cliRequest.commandLine.hasOption("gs")) {
            globalSettingsFile = new File(cliRequest.commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = this.resolveFile(globalSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        cliRequest.request.setGlobalSettingsFile(globalSettingsFile);
        cliRequest.builder.logger().debug("Reading global settings from " + globalSettingsFile);
    }

    protected MAEExecutionRequest populateRequest(CliRequest cliRequest) throws MAEEmbeddingException {
        String threadConfiguration;
        File pom;
        File userToolchainsFile;
        String[] profileOptionValues;
        MAEExecutionRequest request = cliRequest.request;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean debug = cliRequest.builder.shouldShowDebug();
        boolean quiet = cliRequest.builder.shouldBeQuiet();
        boolean showErrors = cliRequest.builder.shouldShowErrors();
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
            cliRequest.builder.configuration().nonInteractive();
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (int i = 0; i < profileOptionValues.length; ++i) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValues[i], ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        Object transferListener = request.isInteractiveMode() ? new InteractiveTransferListener(cliRequest.builder.standardOut()) : new BatchTransferListener(cliRequest.builder.standardOut());
        transferListener.setShowChecksumEvents(false);
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        int loggingLevel = debug ? 0 : (quiet ? 3 : 1);
        if (commandLine.hasOption('t')) {
            userToolchainsFile = new File(commandLine.getOptionValue('t'));
            userToolchainsFile = this.resolveFile(userToolchainsFile, workingDirectory);
        } else {
            userToolchainsFile = DEFAULT_USER_TOOLCHAINS_FILE;
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.systemProperties).setUserProperties(cliRequest.userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setLoggingLevel(loggingLevel).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setUserToolchainsFile(userToolchainsFile);
        if (alternatePomFile != null) {
            pom = this.resolveFile(new File(alternatePomFile), workingDirectory);
            request.setPom(pom);
        } else {
            pom = cliRequest.builder.modelProcessor().locatePom(baseDirectory);
            cliRequest.builder.resetContainer();
            if (pom.isFile()) {
                request.setPom(pom);
            }
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String projectList = commandLine.getOptionValue("pl");
            String[] projects = StringUtils.split((String)projectList, (String)",");
            request.setSelectedProjects(Arrays.asList(projects));
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty(LOCAL_REPO_PROPERTY);
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : request.getSystemProperties().getProperty(THREADS_DEPRECATED);
        if (threadConfiguration != null) {
            request.setPerCoreThreadCount(threadConfiguration.contains("C"));
            if (threadConfiguration.contains("W")) {
                LifecycleWeaveBuilder.setWeaveMode((Properties)request.getUserProperties());
            }
            request.setThreadCount(threadConfiguration.replace("C", "").replace("W", "").replace("auto", ""));
        }
        return request;
    }

    protected File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    protected void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (int i = 0; i < defStrs.length; ++i) {
                MAEMain.setCliProperty(defStrs[i], userProperties);
            }
        }
        systemProperties.putAll((Map<?, ?>)System.getProperties());
    }

    protected static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    public static class ExitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public int exitCode;

        public ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

