/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.main;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MAECLIManager {
    public static final String XAVEN_DEBUG_LOG_HANDLES = "ZX";
    private final Options options = new Options();

    public MAECLIManager() {
        OptionBuilder.withLongOpt((String)"debug-emb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of EMB log-handles to debug.");
        this.options.addOption(OptionBuilder.create((String)XAVEN_DEBUG_LOG_HANDLES));
        this.populateNativeMavenOptions(this.options);
    }

    private void populateNativeMavenOptions(Options options) {
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Force the use of an alternate POM file.");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define a system property");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"offline");
        OptionBuilder.withDescription((String)"Work offline");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display help information");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Display version information");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)"Quiet output - only show errors");
        options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"Produce execution debug output");
        options.addOption(OptionBuilder.create((char)'X'));
        OptionBuilder.withLongOpt((String)"errors");
        OptionBuilder.withDescription((String)"Produce execution error messages");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"non-recursive");
        OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
        options.addOption(OptionBuilder.create((char)'N'));
        OptionBuilder.withLongOpt((String)"update-snapshots");
        OptionBuilder.withDescription((String)"Forces a check for updated releases and snapshots on remote repositories");
        options.addOption(OptionBuilder.create((char)'U'));
        OptionBuilder.withLongOpt((String)"activate-profiles");
        OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"batch-mode");
        OptionBuilder.withDescription((String)"Run in non-interactive (batch) mode");
        options.addOption(OptionBuilder.create((char)'B'));
        OptionBuilder.withLongOpt((String)"no-snapshot-updates");
        OptionBuilder.withDescription((String)"Supress SNAPSHOT updates");
        options.addOption(OptionBuilder.create((String)"nsu"));
        OptionBuilder.withLongOpt((String)"strict-checksums");
        OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
        options.addOption(OptionBuilder.create((char)'C'));
        OptionBuilder.withLongOpt((String)"lax-checksums");
        OptionBuilder.withDescription((String)"Warn if checksums don't match");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"settings");
        OptionBuilder.withDescription((String)"Alternate path for the user settings file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"global-settings");
        OptionBuilder.withDescription((String)"Alternate path for the global settings file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"gs"));
        OptionBuilder.withLongOpt((String)"toolchains");
        OptionBuilder.withDescription((String)"Alternate path for the user toolchains file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"fail-fast");
        OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
        options.addOption(OptionBuilder.create((String)"ff"));
        OptionBuilder.withLongOpt((String)"fail-at-end");
        OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
        options.addOption(OptionBuilder.create((String)"fae"));
        OptionBuilder.withLongOpt((String)"fail-never");
        OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
        options.addOption(OptionBuilder.create((String)"fn"));
        OptionBuilder.withLongOpt((String)"resume-from");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Resume reactor from specified project");
        options.addOption(OptionBuilder.create((String)"rf"));
        OptionBuilder.withLongOpt((String)"projects");
        OptionBuilder.withDescription((String)"Build specified reactor projects instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path.");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"pl"));
        OptionBuilder.withLongOpt((String)"also-make");
        OptionBuilder.withDescription((String)"If project list is specified, also build projects required by the list");
        options.addOption(OptionBuilder.create((String)"am"));
        OptionBuilder.withLongOpt((String)"also-make-dependents");
        OptionBuilder.withDescription((String)"If project list is specified, also build projects that depend on projects on the list");
        options.addOption(OptionBuilder.create((String)"amd"));
        OptionBuilder.withLongOpt((String)"log-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Log file to where all build output will go.");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"show-version");
        OptionBuilder.withDescription((String)"Display version information WITHOUT stopping build");
        options.addOption(OptionBuilder.create((char)'V'));
        OptionBuilder.withLongOpt((String)"encrypt-master-password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Encrypt master security password");
        options.addOption(OptionBuilder.create((String)"emp"));
        OptionBuilder.withLongOpt((String)"encrypt-password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Encrypt server password");
        options.addOption(OptionBuilder.create((String)"ep"));
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Thread count, for instance 2.0C where C is core multiplied");
        options.addOption(OptionBuilder.create((String)"T"));
        OptionBuilder.withLongOpt((String)"no-plugin-registry");
        OptionBuilder.withDescription((String)"Ineffective, only kept for backward compatibility");
        options.addOption(OptionBuilder.create((String)"npr"));
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = this.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    private String[] cleanArgs(String[] args) {
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuilder currentArg = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuilder(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        int cleanedSz = cleaned.size();
        String[] cleanArgs = null;
        cleanArgs = cleanedSz == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    public void displayHelp(PrintStream stdout) {
        stdout.println();
        PrintWriter pw = new PrintWriter(stdout);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 74, "xvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, 1, 3, "\n", false);
        pw.flush();
    }
}

