/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.log;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.repository.ArtifactTransferEvent;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.repository.ArtifactTransferResource;

public class InteractiveTransferListener
implements ArtifactTransferListener {
    private final Map<ArtifactTransferResource, Long> downloads = new ConcurrentHashMap<ArtifactTransferResource, Long>();
    private int lastLength;
    protected PrintStream out;
    private boolean showChecksumEvents;

    public InteractiveTransferListener(PrintStream out) {
        this.out = out;
    }

    protected void doProgress(ArtifactTransferEvent transferEvent) {
        ArtifactTransferResource resource = transferEvent.getResource();
        this.downloads.put(resource, transferEvent.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<ArtifactTransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.out.print(buffer);
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, "                                        ".length());
            buffer.append("                                        ", 0, n);
            spaces -= n;
        }
    }

    public void transferCompleted(ArtifactTransferEvent transferEvent) {
        this.downloads.remove(transferEvent.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        this.out.print(buffer);
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doCompleted(transferEvent);
    }

    protected boolean showEvent(ArtifactTransferEvent event) {
        if (event.getResource() == null) {
            return true;
        }
        String resource = event.getResource().getName();
        if (resource == null || resource.trim().length() == 0) {
            return true;
        }
        if (resource.endsWith(".sha1") || resource.endsWith(".md5")) {
            return this.showChecksumEvents;
        }
        return true;
    }

    public void transferInitiated(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doInitiated(transferEvent);
    }

    protected void doInitiated(ArtifactTransferEvent transferEvent) {
        String message = transferEvent.getRequestType() == 6 ? "Uploading" : "Downloading";
        this.out.println(message + ": " + transferEvent.getResource().getUrl());
    }

    public void transferStarted(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doStarted(transferEvent);
    }

    protected void doStarted(ArtifactTransferEvent transferEvent) {
    }

    public void transferProgress(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doProgress(transferEvent);
    }

    protected void doCompleted(ArtifactTransferEvent transferEvent) {
        ArtifactTransferResource artifact = transferEvent.getResource();
        long contentLength = transferEvent.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = transferEvent.getRequestType() == 6 ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - artifact.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.out.println(type + ": " + artifact.getUrl() + " (" + len + throughput + ")");
        }
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    public boolean isShowChecksumEvents() {
        return this.showChecksumEvents;
    }

    public void setShowChecksumEvents(boolean showChecksumEvents) {
        this.showChecksumEvents = showChecksumEvents;
    }
}

