/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml.config.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.buildcache.xml.config.AttachedOutputs;
import org.apache.maven.buildcache.xml.config.CacheConfig;
import org.apache.maven.buildcache.xml.config.Configuration;
import org.apache.maven.buildcache.xml.config.CoordinatesBase;
import org.apache.maven.buildcache.xml.config.DirName;
import org.apache.maven.buildcache.xml.config.DirScanConfig;
import org.apache.maven.buildcache.xml.config.Discovery;
import org.apache.maven.buildcache.xml.config.EffectivePom;
import org.apache.maven.buildcache.xml.config.Exclude;
import org.apache.maven.buildcache.xml.config.Executables;
import org.apache.maven.buildcache.xml.config.ExecutionConfigurationScan;
import org.apache.maven.buildcache.xml.config.ExecutionControl;
import org.apache.maven.buildcache.xml.config.ExecutionIdsList;
import org.apache.maven.buildcache.xml.config.GoalId;
import org.apache.maven.buildcache.xml.config.GoalReconciliation;
import org.apache.maven.buildcache.xml.config.GoalsList;
import org.apache.maven.buildcache.xml.config.Include;
import org.apache.maven.buildcache.xml.config.Input;
import org.apache.maven.buildcache.xml.config.Local;
import org.apache.maven.buildcache.xml.config.MultiModule;
import org.apache.maven.buildcache.xml.config.Output;
import org.apache.maven.buildcache.xml.config.OutputExclude;
import org.apache.maven.buildcache.xml.config.PathSet;
import org.apache.maven.buildcache.xml.config.PluginConfigurationScan;
import org.apache.maven.buildcache.xml.config.PluginSet;
import org.apache.maven.buildcache.xml.config.ProjectVersioning;
import org.apache.maven.buildcache.xml.config.PropertyName;
import org.apache.maven.buildcache.xml.config.Reconcile;
import org.apache.maven.buildcache.xml.config.Remote;
import org.apache.maven.buildcache.xml.config.TagExclude;
import org.apache.maven.buildcache.xml.config.TagScanConfig;
import org.apache.maven.buildcache.xml.config.TrackedProperty;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BuildCacheConfigXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public BuildCacheConfigXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public BuildCacheConfigXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public CacheConfig read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        CacheConfig cacheConfig = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"cache".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'cache' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'cache'", parser, null);
                }
                cacheConfig = this.parseCacheConfig(parser, strict);
                cacheConfig.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return cacheConfig;
        }
        throw new XmlPullParserException("Expected root element 'cache' but found no element at all: invalid XML document", parser, null);
    }

    public CacheConfig read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public CacheConfig read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public CacheConfig read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)new XmlStreamReader(in), strict);
    }

    public CacheConfig read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)new XmlStreamReader(in));
    }

    private AttachedOutputs parseAttachedOutputs(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        AttachedOutputs attachedOutputs = new AttachedOutputs();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "preservePermissions", null, parsed)) {
                attachedOutputs.setPreservePermissions(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "preservePermissions"), "preservePermissions", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dirNames", null, parsed)) {
                ArrayList<DirName> dirNames = new ArrayList<DirName>();
                while (parser.nextTag() == 2) {
                    if ("dirName".equals(parser.getName())) {
                        dirNames.add(this.parseDirName(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                attachedOutputs.setDirNames(dirNames);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return attachedOutputs;
    }

    private CacheConfig parseCacheConfig(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CacheConfig cacheConfig = new CacheConfig();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                cacheConfig.setConfiguration(this.parseConfiguration(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "input", null, parsed)) {
                cacheConfig.setInput(this.parseInput(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "output", null, parsed)) {
                cacheConfig.setOutput(this.parseOutput(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executionControl", null, parsed)) {
                cacheConfig.setExecutionControl(this.parseExecutionControl(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cacheConfig;
    }

    private Configuration parseConfiguration(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Configuration configuration = new Configuration();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                configuration.setEnabled(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "enabled"), "enabled", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "hashAlgorithm", null, parsed)) {
                configuration.setHashAlgorithm(this.interpolatedTrimmed(parser.nextText(), "hashAlgorithm"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "validateXml", null, parsed)) {
                configuration.setValidateXml(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "validateXml"), "validateXml", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mandatoryClean", null, parsed)) {
                configuration.setMandatoryClean(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "mandatoryClean"), "mandatoryClean", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "multiModule", null, parsed)) {
                configuration.setMultiModule(this.parseMultiModule(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectVersioning", null, parsed)) {
                configuration.setProjectVersioning(this.parseProjectVersioning(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "remote", null, parsed)) {
                configuration.setRemote(this.parseRemote(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "attachedOutputs", null, parsed)) {
                configuration.setAttachedOutputs(this.parseAttachedOutputs(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "local", null, parsed)) {
                configuration.setLocal(this.parseLocal(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "debugs", null, parsed)) {
                ArrayList<String> debugs = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("debug".equals(parser.getName())) {
                        debugs.add(this.interpolatedTrimmed(parser.nextText(), "debugs"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                configuration.setDebugs(debugs);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return configuration;
    }

    private CoordinatesBase parseCoordinatesBase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CoordinatesBase coordinatesBase = new CoordinatesBase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("groupId".equals(name)) {
                coordinatesBase.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                coordinatesBase.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return coordinatesBase;
    }

    private DirName parseDirName(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DirName dirName = new DirName();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("glob".equals(name)) {
                dirName.setGlob(this.interpolatedTrimmed(value, "glob"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        dirName.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return dirName;
    }

    private DirScanConfig parseDirScanConfig(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DirScanConfig dirScanConfig = new DirScanConfig();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("ignoreParent".equals(name)) {
                dirScanConfig.setIgnoreParent(this.getBooleanValue(this.interpolatedTrimmed(value, "ignoreParent"), "ignoreParent", parser, "false"));
                continue;
            }
            if ("mode".equals(name)) {
                dirScanConfig.setMode(this.interpolatedTrimmed(value, "mode"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<TagScanConfig> includes = new ArrayList<TagScanConfig>();
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.parseTagScanConfig(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dirScanConfig.setIncludes(includes);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<TagExclude> excludes = new ArrayList<TagExclude>();
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.parseTagExclude(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dirScanConfig.setExcludes(excludes);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "tagScanConfigs", null, parsed)) {
                ArrayList<TagScanConfig> tagScanConfigs = new ArrayList<TagScanConfig>();
                while (parser.nextTag() == 2) {
                    if ("tagScanConfig".equals(parser.getName())) {
                        tagScanConfigs.add(this.parseTagScanConfig(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                dirScanConfig.setTagScanConfigs(tagScanConfigs);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return dirScanConfig;
    }

    private Discovery parseDiscovery(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Discovery discovery = new Discovery();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "scanProfiles", null, parsed)) {
                ArrayList<String> scanProfiles = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("scanProfile".equals(parser.getName())) {
                        scanProfiles.add(this.interpolatedTrimmed(parser.nextText(), "scanProfiles"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                discovery.setScanProfiles(scanProfiles);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return discovery;
    }

    private EffectivePom parseEffectivePom(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        EffectivePom effectivePom = new EffectivePom();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "excludeProperties", null, parsed)) {
                ArrayList<String> excludeProperties = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("excludeProperty".equals(parser.getName())) {
                        excludeProperties.add(this.interpolatedTrimmed(parser.nextText(), "excludeProperties"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                effectivePom.setExcludeProperties(excludeProperties);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return effectivePom;
    }

    private Exclude parseExclude(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Exclude exclude = new Exclude();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("glob".equals(name)) {
                exclude.setGlob(this.interpolatedTrimmed(value, "glob"));
                continue;
            }
            if ("entryType".equals(name)) {
                exclude.setEntryType(this.interpolatedTrimmed(value, "entryType"));
                continue;
            }
            if ("matcherType".equals(name)) {
                exclude.setMatcherType(this.interpolatedTrimmed(value, "matcherType"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        exclude.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return exclude;
    }

    private Executables parseExecutables(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Executables executables = new Executables();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<PluginSet> plugins = new ArrayList<PluginSet>();
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePluginSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                executables.setPlugins(plugins);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executions", null, parsed)) {
                ArrayList<ExecutionIdsList> executions = new ArrayList<ExecutionIdsList>();
                while (parser.nextTag() == 2) {
                    if ("execution".equals(parser.getName())) {
                        executions.add(this.parseExecutionIdsList(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                executables.setExecutions(executions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goalsLists", null, parsed)) {
                ArrayList<GoalsList> goalsLists = new ArrayList<GoalsList>();
                while (parser.nextTag() == 2) {
                    if ("goalsList".equals(parser.getName())) {
                        goalsLists.add(this.parseGoalsList(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                executables.setGoalsLists(goalsLists);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return executables;
    }

    private ExecutionConfigurationScan parseExecutionConfigurationScan(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ExecutionConfigurationScan executionConfigurationScan = new ExecutionConfigurationScan();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("ignoreParentConfig".equals(name)) {
                executionConfigurationScan.setIgnoreParentConfig(this.getBooleanValue(this.interpolatedTrimmed(value, "ignoreParentConfig"), "ignoreParentConfig", parser, "false"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "execIds", null, parsed)) {
                ArrayList<String> execIds = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("execId".equals(parser.getName())) {
                        execIds.add(this.interpolatedTrimmed(parser.nextText(), "execIds"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                executionConfigurationScan.setExecIds(execIds);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dirScan", null, parsed)) {
                executionConfigurationScan.setDirScan(this.parseDirScanConfig(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return executionConfigurationScan;
    }

    private ExecutionControl parseExecutionControl(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ExecutionControl executionControl = new ExecutionControl();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "runAlways", null, parsed)) {
                executionControl.setRunAlways(this.parseExecutables(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "ignoreMissing", null, parsed)) {
                executionControl.setIgnoreMissing(this.parseExecutables(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reconcile", null, parsed)) {
                executionControl.setReconcile(this.parseReconcile(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return executionControl;
    }

    private ExecutionIdsList parseExecutionIdsList(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ExecutionIdsList executionIdsList = new ExecutionIdsList();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("groupId".equals(name)) {
                executionIdsList.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                executionIdsList.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "execIds", null, parsed)) {
                ArrayList<String> execIds = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("execId".equals(parser.getName())) {
                        execIds.add(this.interpolatedTrimmed(parser.nextText(), "execIds"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                executionIdsList.setExecIds(execIds);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return executionIdsList;
    }

    private GoalId parseGoalId(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        GoalId goalId = new GoalId();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("goal".equals(name)) {
                goalId.setGoal(this.interpolatedTrimmed(value, "goal"));
                continue;
            }
            if ("groupId".equals(name)) {
                goalId.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                goalId.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return goalId;
    }

    private GoalReconciliation parseGoalReconciliation(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        GoalReconciliation goalReconciliation = new GoalReconciliation();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("goal".equals(name)) {
                goalReconciliation.setGoal(this.interpolatedTrimmed(value, "goal"));
                continue;
            }
            if ("groupId".equals(name)) {
                goalReconciliation.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                goalReconciliation.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "reconciles", null, parsed)) {
                ArrayList<TrackedProperty> reconciles = new ArrayList<TrackedProperty>();
                while (parser.nextTag() == 2) {
                    if ("reconcile".equals(parser.getName())) {
                        reconciles.add(this.parseTrackedProperty(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                goalReconciliation.setReconciles(reconciles);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "logs", null, parsed)) {
                ArrayList<PropertyName> logs = new ArrayList<PropertyName>();
                while (parser.nextTag() == 2) {
                    if ("log".equals(parser.getName())) {
                        logs.add(this.parsePropertyName(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                goalReconciliation.setLogs(logs);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nologs", null, parsed)) {
                ArrayList<PropertyName> nologs = new ArrayList<PropertyName>();
                while (parser.nextTag() == 2) {
                    if ("nolog".equals(parser.getName())) {
                        nologs.add(this.parsePropertyName(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                goalReconciliation.setNologs(nologs);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "logAll", null, parsed)) {
                goalReconciliation.setLogAll(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "logAll"), "logAll", parser, "true"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return goalReconciliation;
    }

    private GoalsList parseGoalsList(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        GoalsList goalsList = new GoalsList();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("groupId".equals(name)) {
                goalsList.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                goalsList.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("goal".equals(parser.getName())) {
                        goals.add(this.interpolatedTrimmed(parser.nextText(), "goals"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                goalsList.setGoals(goals);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return goalsList;
    }

    private Include parseInclude(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Include include = new Include();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("recursive".equals(name)) {
                include.setRecursive(this.getBooleanValue(this.interpolatedTrimmed(value, "recursive"), "recursive", parser, "true"));
                continue;
            }
            if ("glob".equals(name)) {
                include.setGlob(this.interpolatedTrimmed(value, "glob"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        include.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return include;
    }

    private Input parseInput(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Input input = new Input();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "global", null, parsed)) {
                input.setGlobal(this.parsePathSet(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<PluginConfigurationScan> plugins = new ArrayList<PluginConfigurationScan>();
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePluginConfigurationScan(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                input.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return input;
    }

    private Local parseLocal(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Local local = new Local();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "location", null, parsed)) {
                local.setLocation(this.interpolatedTrimmed(parser.nextText(), "location"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "maxBuildsCached", null, parsed)) {
                local.setMaxBuildsCached(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "maxBuildsCached"), "maxBuildsCached", parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return local;
    }

    private MultiModule parseMultiModule(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MultiModule multiModule = new MultiModule();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "discovery", null, parsed)) {
                multiModule.setDiscovery(this.parseDiscovery(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return multiModule;
    }

    private Output parseOutput(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Output output = new Output();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "exclude", null, parsed)) {
                output.setExclude(this.parseOutputExclude(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return output;
    }

    private OutputExclude parseOutputExclude(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        OutputExclude outputExclude = new OutputExclude();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "patterns", null, parsed)) {
                ArrayList<String> patterns = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("pattern".equals(parser.getName())) {
                        patterns.add(this.interpolatedTrimmed(parser.nextText(), "patterns"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                outputExclude.setPatterns(patterns);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return outputExclude;
    }

    private PathSet parsePathSet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PathSet pathSet = new PathSet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "glob", null, parsed)) {
                pathSet.setGlob(this.interpolatedTrimmed(parser.nextText(), "glob"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<Include> includes = new ArrayList<Include>();
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.parseInclude(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                pathSet.setIncludes(includes);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<Exclude> excludes = new ArrayList<Exclude>();
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.parseExclude(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                pathSet.setExcludes(excludes);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pathSet;
    }

    private PluginConfigurationScan parsePluginConfigurationScan(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginConfigurationScan pluginConfigurationScan = new PluginConfigurationScan();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("excludeDependencies".equals(name)) {
                pluginConfigurationScan.setExcludeDependencies(this.getBooleanValue(this.interpolatedTrimmed(value, "excludeDependencies"), "excludeDependencies", parser, "false"));
                continue;
            }
            if ("groupId".equals(name)) {
                pluginConfigurationScan.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                pluginConfigurationScan.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "effectivePom", null, parsed)) {
                pluginConfigurationScan.setEffectivePom(this.parseEffectivePom(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dirScan", null, parsed)) {
                pluginConfigurationScan.setDirScan(this.parseDirScanConfig(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executions", null, parsed)) {
                ArrayList<ExecutionConfigurationScan> executions = new ArrayList<ExecutionConfigurationScan>();
                while (parser.nextTag() == 2) {
                    if ("execution".equals(parser.getName())) {
                        executions.add(this.parseExecutionConfigurationScan(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                pluginConfigurationScan.setExecutions(executions);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pluginConfigurationScan;
    }

    private PluginSet parsePluginSet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginSet pluginSet = new PluginSet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("groupId".equals(name)) {
                pluginSet.setGroupId(this.interpolatedTrimmed(value, "groupId"));
                continue;
            }
            if ("artifactId".equals(name)) {
                pluginSet.setArtifactId(this.interpolatedTrimmed(value, "artifactId"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return pluginSet;
    }

    private ProjectVersioning parseProjectVersioning(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ProjectVersioning projectVersioning = new ProjectVersioning();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("adjustMetaInf".equals(name)) {
                projectVersioning.setAdjustMetaInf(this.getBooleanValue(this.interpolatedTrimmed(value, "adjustMetaInf"), "adjustMetaInf", parser, "false"));
                continue;
            }
            if ("calculateProjectVersionChecksum".equals(name)) {
                projectVersioning.setCalculateProjectVersionChecksum(this.getBooleanValue(this.interpolatedTrimmed(value, "calculateProjectVersionChecksum"), "calculateProjectVersionChecksum", parser, "false"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return projectVersioning;
    }

    private PropertyName parsePropertyName(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PropertyName propertyName = new PropertyName();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("propertyName".equals(name)) {
                propertyName.setPropertyName(this.interpolatedTrimmed(value, "propertyName"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        propertyName.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return propertyName;
    }

    private Reconcile parseReconcile(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Reconcile reconcile = new Reconcile();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("logAllProperties".equals(name)) {
                reconcile.setLogAllProperties(this.getBooleanValue(this.interpolatedTrimmed(value, "logAllProperties"), "logAllProperties", parser, "true"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<GoalReconciliation> plugins = new ArrayList<GoalReconciliation>();
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parseGoalReconciliation(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                reconcile.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return reconcile;
    }

    private Remote parseRemote(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Remote remote = new Remote();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("enabled".equals(name)) {
                remote.setEnabled(this.getBooleanValue(this.interpolatedTrimmed(value, "enabled"), "enabled", parser, "true"));
                continue;
            }
            if ("saveToRemote".equals(name)) {
                remote.setSaveToRemote(this.getBooleanValue(this.interpolatedTrimmed(value, "saveToRemote"), "saveToRemote", parser, "false"));
                continue;
            }
            if ("transport".equals(name)) {
                remote.setTransport(this.interpolatedTrimmed(value, "transport"));
                continue;
            }
            if ("id".equals(name)) {
                remote.setId(this.interpolatedTrimmed(value, "id"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                remote.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return remote;
    }

    private TagExclude parseTagExclude(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TagExclude tagExclude = new TagExclude();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("tagName".equals(name)) {
                tagExclude.setTagName(this.interpolatedTrimmed(value, "tagName"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return tagExclude;
    }

    private TagScanConfig parseTagScanConfig(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TagScanConfig tagScanConfig = new TagScanConfig();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("recursive".equals(name)) {
                tagScanConfig.setRecursive(this.getBooleanValue(this.interpolatedTrimmed(value, "recursive"), "recursive", parser, "true"));
                continue;
            }
            if ("glob".equals(name)) {
                tagScanConfig.setGlob(this.interpolatedTrimmed(value, "glob"));
                continue;
            }
            if ("tagName".equals(name)) {
                tagScanConfig.setTagName(this.interpolatedTrimmed(value, "tagName"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return tagScanConfig;
    }

    private TrackedProperty parseTrackedProperty(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TrackedProperty trackedProperty = new TrackedProperty();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("propertyName".equals(name)) {
                trackedProperty.setPropertyName(this.interpolatedTrimmed(value, "propertyName"));
                continue;
            }
            if ("skipValue".equals(name)) {
                trackedProperty.setSkipValue(this.interpolatedTrimmed(value, "skipValue"));
                continue;
            }
            if ("defaultValue".equals(name)) {
                trackedProperty.setDefaultValue(this.interpolatedTrimmed(value, "defaultValue"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        trackedProperty.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return trackedProperty;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

