/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import org.apache.maven.buildcache.hash.Hash;
import org.apache.maven.buildcache.hash.ThreadLocalDigest;

public class SHA
implements Hash.Factory {
    private static final ThreadLocal<MessageDigest> ALGORITHM = new ThreadLocal();
    private static final ThreadLocal<MessageDigest> CHECKSUM = new ThreadLocal();
    private final String algorithm;

    SHA(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public Hash.Algorithm algorithm() {
        return new Algorithm(ThreadLocalDigest.get(ALGORITHM, this.algorithm));
    }

    @Override
    public Hash.Checksum checksum(int count) {
        return new Checksum(ThreadLocalDigest.get(CHECKSUM, this.algorithm));
    }

    private static class Algorithm
    implements Hash.Algorithm {
        private final MessageDigest digest;

        private Algorithm(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public byte[] hash(byte[] array) {
            return this.digest.digest(array);
        }

        @Override
        public byte[] hash(Path path) throws IOException {
            return this.hash(Files.readAllBytes(path));
        }
    }

    private static class Checksum
    implements Hash.Checksum {
        private final MessageDigest digest;

        private Checksum(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void update(byte[] hash) {
            this.digest.update(hash);
        }

        @Override
        public byte[] digest() {
            return this.digest.digest();
        }
    }
}

