/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.buildcache.xml.build.Scm;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;

public class CacheUtils {
    public static boolean isPom(MavenProject project) {
        return project.getPackaging().equals("pom");
    }

    public static boolean isPom(Dependency dependency) {
        return dependency.getType().equals("pom");
    }

    public static boolean isSnapshot(String version) {
        return version.endsWith("SNAPSHOT") || version.endsWith("LATEST");
    }

    public static String normalizedName(Artifact artifact) {
        ArtifactHandler artifactHandler;
        if (artifact.getFile() == null) {
            return null;
        }
        StringBuilder filename = new StringBuilder(artifact.getArtifactId());
        if (artifact.hasClassifier()) {
            filename.append("-").append(artifact.getClassifier());
        }
        if ((artifactHandler = artifact.getArtifactHandler()) != null && StringUtils.isNotBlank((CharSequence)artifactHandler.getExtension())) {
            filename.append(".").append(artifactHandler.getExtension());
        }
        return filename.toString();
    }

    public static String mojoExecutionKey(MojoExecution mojo) {
        return String.join((CharSequence)":", Arrays.asList((String)StringUtils.defaultIfEmpty((CharSequence)mojo.getExecutionId(), (CharSequence)"emptyExecId"), (String)StringUtils.defaultIfEmpty((CharSequence)mojo.getGoal(), (CharSequence)"emptyGoal"), (String)StringUtils.defaultIfEmpty((CharSequence)mojo.getLifecyclePhase(), (CharSequence)"emptyLifecyclePhase"), (String)StringUtils.defaultIfEmpty((CharSequence)mojo.getArtifactId(), (CharSequence)"emptyArtifactId"), (String)StringUtils.defaultIfEmpty((CharSequence)mojo.getGroupId(), (CharSequence)"emptyGroupId")));
    }

    public static Path getMultimoduleRoot(MavenSession session) {
        return session.getRequest().getMultiModuleProjectDirectory().toPath();
    }

    public static Scm readGitInfo(MavenSession session) throws IOException {
        Path headFile;
        Scm scmCandidate = new Scm();
        Path gitDir = CacheUtils.getMultimoduleRoot(session).resolve(".git");
        if (Files.isDirectory(gitDir, new LinkOption[0]) && Files.exists(headFile = gitDir.resolve("HEAD"), new LinkOption[0])) {
            String headRef = CacheUtils.readFirstLine(headFile, "<missing branch>");
            if (headRef.startsWith("ref: ")) {
                String branch = Strings.CS.removeStart(headRef, (CharSequence)"ref: ").trim();
                scmCandidate.setSourceBranch(branch);
                Path refPath = gitDir.resolve(branch);
                if (Files.exists(refPath, new LinkOption[0])) {
                    String revision = CacheUtils.readFirstLine(refPath, "<missing revision>");
                    scmCandidate.setRevision(revision.trim());
                }
            } else {
                scmCandidate.setSourceBranch(headRef);
                scmCandidate.setRevision(headRef);
            }
        }
        return scmCandidate;
    }

    private static String readFirstLine(Path path, String defaultValue) throws IOException {
        try (Stream<String> lines = Files.lines(path);){
            String string = lines.findFirst().orElse(defaultValue);
            return string;
        }
    }

    public static <T> T getLast(List<T> list) {
        int size = list.size();
        if (size > 0) {
            return list.get(size - 1);
        }
        throw new NoSuchElementException();
    }

    public static boolean isArchive(File file) {
        String fileName = file.getName();
        if (!file.isFile() || file.isHidden()) {
            return false;
        }
        return Strings.CS.endsWithAny((CharSequence)fileName, new CharSequence[]{".jar", ".zip", ".war", ".ear"});
    }

    public static boolean zip(final Path dir, Path zip, String glob, boolean preservePermissions) throws IOException {
        final MutableBoolean hasFiles = new MutableBoolean();
        final boolean supportsPosix = preservePermissions && dir.getFileSystem().supportedFileAttributeViews().contains("posix");
        try (final ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(Files.newOutputStream(zip, new OpenOption[0]));){
            final PathMatcher matcher = "*".equals(glob) ? null : FileSystems.getDefault().getPathMatcher("glob:" + glob);
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (matcher == null || matcher.matches(path.getFileName())) {
                        ZipArchiveEntry zipEntry = new ZipArchiveEntry(dir.relativize(path).toString());
                        if (supportsPosix) {
                            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                            zipEntry.setUnixMode(CacheUtils.permissionsToMode(permissions));
                        }
                        zipOutputStream.putArchiveEntry(zipEntry);
                        Files.copy(path, (OutputStream)zipOutputStream);
                        hasFiles.setTrue();
                        zipOutputStream.closeArchiveEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return hasFiles.booleanValue();
    }

    public static void unzip(Path zip, Path out, boolean preservePermissions) throws IOException {
        boolean supportsPosix = preservePermissions && out.getFileSystem().supportedFileAttributeViews().contains("posix");
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipArchiveEntry entry = zis.getNextEntry();
            while (entry != null) {
                int unixMode;
                Path file = out.resolve(entry.getName());
                if (!file.normalize().startsWith(out.normalize())) {
                    throw new RuntimeException("Bad zip entry");
                }
                if (entry.isDirectory()) {
                    Files.createDirectory(file, new FileAttribute[0]);
                } else {
                    Path parent = file.getParent();
                    Files.createDirectories(parent, new FileAttribute[0]);
                    Files.copy((InputStream)zis, file, StandardCopyOption.REPLACE_EXISTING);
                }
                Files.setLastModifiedTime(file, FileTime.fromMillis(entry.getTime()));
                if (supportsPosix && (unixMode = entry.getUnixMode()) != 0) {
                    Set<PosixFilePermission> permissions = CacheUtils.modeToPermissions(unixMode);
                    Files.setPosixFilePermissions(file, permissions);
                }
                entry = zis.getNextEntry();
            }
        }
    }

    public static <T> void debugPrintCollection(Logger logger, Collection<T> values, String heading, String elementCaption) {
        if (logger.isDebugEnabled() && values != null && !values.isEmpty()) {
            int size = values.size();
            int i = 0;
            logger.debug("{} (total {})", (Object)heading, (Object)size);
            for (T value : values) {
                logger.debug("{} {} of {} : {}", new Object[]{elementCaption, ++i, size, value});
            }
        }
    }

    private static int permissionsToMode(Set<PosixFilePermission> permissions) {
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            return 33261;
        }
        return 33188;
    }

    private static Set<PosixFilePermission> modeToPermissions(int mode) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if ((mode & 0x40) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        return permissions;
    }
}

