/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheContext;
import org.apache.maven.buildcache.CacheResult;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.RemoteCacheRepository;
import org.apache.maven.buildcache.xml.Build;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.CacheSource;
import org.apache.maven.buildcache.xml.XmlService;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.buildcache.xml.report.CacheReport;
import org.apache.maven.buildcache.xml.report.ProjectReport;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named(value="resolver")
public class RemoteCacheRepositoryImpl
implements RemoteCacheRepository,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCacheRepositoryImpl.class);
    private final XmlService xmlService;
    private final CacheConfig cacheConfig;
    private final Transporter transporter;
    private final AtomicReference<CacheReport> cacheReportSupplier = new AtomicReference();

    @Inject
    public RemoteCacheRepositoryImpl(XmlService xmlService, CacheConfig cacheConfig, MavenSession mavenSession, TransporterProvider transporterProvider) throws Exception {
        this.xmlService = xmlService;
        this.cacheConfig = cacheConfig;
        if (cacheConfig.isRemoteCacheEnabled()) {
            RepositorySystemSession session = mavenSession.getRepositorySession();
            RemoteRepository repo = new RemoteRepository.Builder(cacheConfig.getId(), "cache", cacheConfig.getUrl()).build();
            RemoteRepository mirror = session.getMirrorSelector().getMirror(repo);
            RemoteRepository repoOrMirror = mirror != null ? mirror : repo;
            Proxy proxy = session.getProxySelector().getProxy(repoOrMirror);
            Authentication auth = session.getAuthenticationSelector().getAuthentication(repoOrMirror);
            RemoteRepository repository = new RemoteRepository.Builder(repoOrMirror).setProxy(proxy).setAuthentication(auth).build();
            this.transporter = transporterProvider.newTransporter(session, repository);
        } else {
            this.transporter = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.transporter != null) {
            this.transporter.close();
        }
    }

    @Override
    @Nonnull
    public Optional<Build> findBuild(CacheContext context) throws IOException {
        String resourceUrl = this.getResourceUrl(context, "buildinfo.xml");
        return this.getResourceContent(resourceUrl).map(content -> new Build(this.xmlService.loadBuild((byte[])content), CacheSource.REMOTE));
    }

    @Override
    @Nonnull
    public boolean getArtifactContent(CacheContext context, Artifact artifact, Path target) throws IOException {
        return this.getResourceContent(this.getResourceUrl(context, artifact.getFileName()), target);
    }

    @Override
    public void saveBuildInfo(CacheResult cacheResult, Build build) throws IOException {
        String resourceUrl = this.getResourceUrl(cacheResult.getContext(), "buildinfo.xml");
        this.putToRemoteCache(this.xmlService.toBytes(build.getDto()), resourceUrl);
    }

    @Override
    public void saveCacheReport(String buildId, MavenSession session, CacheReport cacheReport) throws IOException {
        MavenProject rootProject = session.getTopLevelProject();
        String resourceUrl = "v1/" + rootProject.getGroupId() + "/" + rootProject.getArtifactId() + "/" + buildId + "/" + "build-cache-report.xml";
        this.putToRemoteCache(this.xmlService.toBytes(cacheReport), resourceUrl);
    }

    @Override
    public void saveArtifactFile(CacheResult cacheResult, org.apache.maven.artifact.Artifact artifact) throws IOException {
        String resourceUrl = this.getResourceUrl(cacheResult.getContext(), CacheUtils.normalizedName(artifact));
        this.putToRemoteCache(artifact.getFile(), resourceUrl);
    }

    @Nonnull
    public Optional<byte[]> getResourceContent(String url) throws IOException {
        try {
            LOGGER.info("Downloading {}", (Object)this.getFullUrl(url));
            GetTask task = new GetTask(new URI(url));
            this.transporter.get(task);
            return Optional.of(task.getDataBytes());
        }
        catch (Exception e) {
            LOGGER.info("Cannot download {}", (Object)this.getFullUrl(url), (Object)e);
            return Optional.empty();
        }
    }

    public boolean getResourceContent(String url, Path target) throws IOException {
        try {
            LOGGER.info("Downloading {}", (Object)this.getFullUrl(url));
            GetTask task = new GetTask(new URI(url)).setDataFile(target.toFile());
            this.transporter.get(task);
            return true;
        }
        catch (Exception e) {
            LOGGER.info("Cannot download {}: {}", (Object)this.getFullUrl(url), (Object)e.toString());
            return false;
        }
    }

    @Override
    @Nonnull
    public String getResourceUrl(CacheContext context, String filename) {
        return this.getResourceUrl(filename, context.getProject().getGroupId(), context.getProject().getArtifactId(), context.getInputInfo().getChecksum());
    }

    private String getResourceUrl(String filename, String groupId, String artifactId, String checksum) {
        return "v1/" + groupId + "/" + artifactId + "/" + checksum + "/" + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToRemoteCache(byte[] bytes, String url) throws IOException {
        Path tmp = Files.createTempFile("mbce-", ".tmp", new FileAttribute[0]);
        try {
            Files.write(tmp, bytes, new OpenOption[0]);
            PutTask put = new PutTask(new URI(url));
            put.setDataFile(tmp.toFile());
            this.transporter.put(put);
            LOGGER.info("Saved to remote cache {}", (Object)this.getFullUrl(url));
        }
        catch (Exception e) {
            LOGGER.info("Unable to save to remote cache {}", (Object)this.getFullUrl(url), (Object)e);
        }
        finally {
            Files.deleteIfExists(tmp);
        }
    }

    private void putToRemoteCache(File file, String url) throws IOException {
        try {
            PutTask put = new PutTask(new URI(url));
            put.setDataFile(file);
            this.transporter.put(put);
            LOGGER.info("Saved to remote cache {}", (Object)this.getFullUrl(url));
        }
        catch (Exception e) {
            LOGGER.info("Unable to save to remote cache {}", (Object)this.getFullUrl(url), (Object)e);
        }
    }

    @Override
    @Nonnull
    public Optional<Build> findBaselineBuild(MavenProject project) {
        String url;
        Optional<List> cachedProjectsHolder = this.findCacheInfo().map(CacheReport::getProjects);
        if (!cachedProjectsHolder.isPresent()) {
            return Optional.empty();
        }
        List projects = cachedProjectsHolder.get();
        Optional<ProjectReport> projectReportHolder = projects.stream().filter(p -> project.getArtifactId().equals(p.getArtifactId()) && project.getGroupId().equals(p.getGroupId())).findFirst();
        if (!projectReportHolder.isPresent()) {
            return Optional.empty();
        }
        ProjectReport projectReport = projectReportHolder.get();
        if (projectReport.getUrl() != null) {
            url = projectReport.getUrl();
            LOGGER.info("Retrieving baseline buildinfo: {}", (Object)url);
        } else {
            url = this.getResourceUrl("buildinfo.xml", project.getGroupId(), project.getArtifactId(), projectReport.getChecksum());
            LOGGER.info("Baseline project record doesn't have url, trying default location {}", (Object)url);
        }
        try {
            return this.getResourceContent(url).map(content -> new Build(this.xmlService.loadBuild((byte[])content), CacheSource.REMOTE));
        }
        catch (Exception e) {
            LOGGER.warn("Error restoring baseline build at url: {}, skipping diff", (Object)url, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<CacheReport> findCacheInfo() {
        Optional<CacheReport> report = Optional.ofNullable(this.cacheReportSupplier.get());
        if (!report.isPresent()) {
            try {
                LOGGER.info("Downloading baseline cache report from: {}", (Object)this.cacheConfig.getBaselineCacheUrl());
                report = this.getResourceContent(this.cacheConfig.getBaselineCacheUrl()).map(this.xmlService::loadCacheReport);
            }
            catch (Exception e) {
                LOGGER.error("Error downloading baseline report from: {}, skipping diff.", (Object)this.cacheConfig.getBaselineCacheUrl(), (Object)e);
                report = Optional.empty();
            }
            this.cacheReportSupplier.compareAndSet(null, report.orElse(null));
        }
        return report;
    }

    private String getFullUrl(String url) {
        return this.cacheConfig.getUrl() + "/" + url;
    }
}

