/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import org.apache.maven.doxia.module.docbook.DocbookMarkup;
import org.apache.maven.doxia.module.docbook.DocbookUtils;
import org.apache.maven.doxia.module.docbook.SimplifiedDocbookMarkup;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DocBookSink
extends AbstractXmlSink
implements DocbookMarkup,
SimplifiedDocbookMarkup {
    public static final String DEFAULT_SGML_PUBLIC_ID = "-//OASIS//DTD DocBook V4.4//EN";
    public static final String DEFAULT_XML_PUBLIC_ID = "-//OASIS//DTD DocBook V4.4//EN";
    public static final String DEFAULT_XML_SYSTEM_ID = "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd";
    public static final String DEFAULT_SGML_SYSTEM_ID = "http://www.oasis-open.org/docbook/sgml/4.4/docbookx.dtd";
    private PrintWriter out;
    private boolean xmlMode = false;
    private String styleSheet = null;
    private String lang = null;
    private String publicId = null;
    private String systemId = null;
    private String italicBeginTag;
    private String italicEndTag;
    private String boldBeginTag;
    private String boldEndTag;
    private String monospacedBeginTag;
    private String monospacedEndTag;
    private String horizontalRuleElement;
    private String pageBreakElement;
    private String lineBreakElement;
    private String graphicsFileName;
    private boolean hasTitle;
    private boolean authorDateFlag;
    private boolean verbatimFlag;
    private boolean externalLinkFlag;
    private boolean tableHasCaption;
    private PrintWriter savedOut;
    private String tableRows;
    private StringWriter tableRowsWriter;
    private boolean tableHasGrid;
    private boolean skip;
    private boolean paragraph;
    private String encoding;
    private Map<String, Set<String>> warnMessages;

    protected DocBookSink(Writer writer) {
        this(writer, null);
    }

    protected DocBookSink(Writer writer, String encoding) {
        this.out = new PrintWriter(writer);
        this.encoding = encoding;
        this.setItalicElement("<emphasis>");
        this.setBoldElement("<emphasis role=\"bold\">");
        this.setMonospacedElement("<literal>");
        this.setHorizontalRuleElement("<!-- HR -->");
        this.setPageBreakElement("<!-- PB -->");
        this.setLineBreakElement("<!-- LB -->");
    }

    protected DocBookSink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.lang = languageId;
    }

    public static final String escapeSGML(String text, boolean xmlMode) {
        return HtmlTools.escapeHTML((String)text, (boolean)xmlMode);
    }

    public void setXMLMode(boolean mode) {
        this.xmlMode = mode;
    }

    public boolean isXMLMode() {
        return this.xmlMode;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStyleSheet(String sheet) {
        this.styleSheet = sheet;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLanguage(String language) {
        this.lang = language;
    }

    public String getLanguage() {
        return this.lang;
    }

    public void setItalicElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.italicBeginTag = tag;
        this.italicEndTag = this.makeEndTag(this.italicBeginTag);
    }

    private String makeEndTag(String beginTag) {
        int length = beginTag.length();
        if (length == 0) {
            return "";
        }
        if (beginTag.charAt(0) != '<' || beginTag.charAt(length - 1) != '>') {
            throw new IllegalArgumentException("'" + beginTag + "', not a tag");
        }
        StringTokenizer tokens = new StringTokenizer(beginTag, "<> \t\n\r\f");
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("'" + beginTag + "', invalid tag");
        }
        return "</" + tokens.nextToken() + ">";
    }

    public String getItalicElement() {
        return this.italicBeginTag;
    }

    public void setBoldElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.boldBeginTag = tag;
        this.boldEndTag = this.makeEndTag(this.boldBeginTag);
    }

    public String getBoldElement() {
        return this.boldBeginTag;
    }

    public void setMonospacedElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.monospacedBeginTag = tag;
        this.monospacedEndTag = this.makeEndTag(this.monospacedBeginTag);
    }

    public String getMonospacedElement() {
        return this.monospacedBeginTag;
    }

    public void setHorizontalRuleElement(String element) {
        this.horizontalRuleElement = element;
    }

    public String getHorizontalRuleElement() {
        return this.horizontalRuleElement;
    }

    public void setPageBreakElement(String element) {
        this.pageBreakElement = element;
    }

    public String getPageBreakElement() {
        return this.pageBreakElement;
    }

    public void setLineBreakElement(String element) {
        this.lineBreakElement = element;
    }

    public String getLineBreakElement() {
        return this.lineBreakElement;
    }

    protected void resetState() {
        this.init();
    }

    protected void init() {
        this.hasTitle = false;
        this.authorDateFlag = false;
        this.verbatimFlag = false;
        this.externalLinkFlag = false;
        this.graphicsFileName = null;
        this.tableHasCaption = false;
        this.savedOut = null;
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void head() {
        this.init();
        MutableAttributeSet att = this.writeXmlHeader("article");
        this.writeStartTag(SimplifiedDocbookMarkup.ARTICLE_TAG, att);
    }

    protected MutableAttributeSet writeXmlHeader(String root) {
        this.markup("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.markup(" encoding=\"" + this.encoding + "\"");
        }
        this.markup("?>");
        if (this.styleSheet != null) {
            this.markup("<?xml-stylesheet type=\"text/css\" href=\"" + this.styleSheet + "\" ?>");
        }
        this.markup("<!DOCTYPE " + root + " PUBLIC");
        String pubId = this.publicId == null ? "-//OASIS//DTD Simplified DocBook XML V1.1//EN" : this.publicId;
        this.markup(" \"" + pubId + "\"");
        String sysId = this.systemId;
        if (sysId == null) {
            sysId = "http://www.oasis-open.org/docbook/xml/simple/1.1/sdocbook.dtd";
        }
        this.markup(" \"" + sysId + "\">");
        SimpleAttributeSet att = new SimpleAttributeSet();
        if (this.lang != null) {
            att.addAttribute("lang", this.lang);
        }
        return att;
    }

    public void head_() {
        if (this.hasTitle) {
            this.writeEndTag(SimplifiedDocbookMarkup.ARTICLEINFO_TAG);
            this.hasTitle = false;
        }
    }

    public void title() {
        this.writeStartTag(SimplifiedDocbookMarkup.ARTICLEINFO_TAG);
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
        this.hasTitle = true;
    }

    public void title_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void author() {
        this.authorDateFlag = true;
        this.writeStartTag(SimplifiedDocbookMarkup.CORPAUTHOR_TAG);
    }

    public void author_() {
        this.writeEndTag(SimplifiedDocbookMarkup.CORPAUTHOR_TAG);
        this.authorDateFlag = false;
    }

    public void date() {
        this.authorDateFlag = true;
        this.writeStartTag(SimplifiedDocbookMarkup.DATE_TAG);
    }

    public void date_() {
        this.writeEndTag(SimplifiedDocbookMarkup.DATE_TAG);
        this.authorDateFlag = false;
    }

    public void body_() {
        this.writeEndTag(SimplifiedDocbookMarkup.ARTICLE_TAG);
        this.out.flush();
        this.init();
    }

    public void section1() {
        this.writeStartTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section1_() {
        this.writeEndTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section2() {
        this.writeStartTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section2_() {
        this.writeEndTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section3() {
        this.writeStartTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section3_() {
        this.writeEndTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section4() {
        this.writeStartTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section4_() {
        this.writeEndTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section5() {
        this.writeStartTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void section5_() {
        this.writeEndTag(SimplifiedDocbookMarkup.SECTION_TAG);
    }

    public void sectionTitle() {
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle1() {
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle1_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle2() {
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle2_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle3() {
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle3_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle4() {
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle4_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle5() {
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void sectionTitle5_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void list() {
        this.paragraph_();
        this.writeStartTag(SimplifiedDocbookMarkup.ITEMIZEDLIST_TAG);
    }

    public void list_() {
        this.writeEndTag(SimplifiedDocbookMarkup.ITEMIZEDLIST_TAG);
    }

    public void listItem() {
        this.writeStartTag(SimplifiedDocbookMarkup.LISTITEM_TAG);
        this.paragraph();
    }

    public void listItem_() {
        this.paragraph_();
        this.writeEndTag(SimplifiedDocbookMarkup.LISTITEM_TAG);
    }

    public void numberedList(int numbering) {
        String numeration = DocbookUtils.docbookListNumbering(numbering);
        this.paragraph_();
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("numeration", numeration);
        this.writeStartTag(SimplifiedDocbookMarkup.ORDEREDLIST_TAG, att);
    }

    public void numberedList_() {
        this.writeEndTag(SimplifiedDocbookMarkup.ORDEREDLIST_TAG);
    }

    public void numberedListItem() {
        this.writeStartTag(SimplifiedDocbookMarkup.LISTITEM_TAG);
        this.paragraph();
    }

    public void numberedListItem_() {
        this.paragraph_();
        this.writeEndTag(SimplifiedDocbookMarkup.LISTITEM_TAG);
    }

    public void definitionList() {
        this.paragraph_();
        this.writeStartTag(SimplifiedDocbookMarkup.VARIABLELIST_TAG);
    }

    public void definitionList_() {
        this.writeEndTag(SimplifiedDocbookMarkup.VARIABLELIST_TAG);
    }

    public void definitionListItem() {
        this.writeStartTag(SimplifiedDocbookMarkup.VARLISTENTRY_TAG);
    }

    public void definitionListItem_() {
        this.writeEndTag(SimplifiedDocbookMarkup.VARLISTENTRY_TAG);
    }

    public void definedTerm() {
        this.writeStartTag(SimplifiedDocbookMarkup.TERM_TAG);
    }

    public void definedTerm_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TERM_TAG);
    }

    public void definition() {
        this.writeStartTag(SimplifiedDocbookMarkup.LISTITEM_TAG);
        this.paragraph();
    }

    public void definition_() {
        this.paragraph_();
        this.writeEndTag(SimplifiedDocbookMarkup.LISTITEM_TAG);
    }

    public void paragraph() {
        if (!this.paragraph) {
            this.writeStartTag(SimplifiedDocbookMarkup.PARA_TAG);
            this.paragraph = true;
        }
    }

    public void paragraph_() {
        if (this.paragraph) {
            this.writeEndTag(SimplifiedDocbookMarkup.PARA_TAG);
            this.paragraph = false;
        }
    }

    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.paragraph_();
        this.writeStartTag(SimplifiedDocbookMarkup.PROGRAMLISTING_TAG);
    }

    public void verbatim_() {
        this.writeEndTag(SimplifiedDocbookMarkup.PROGRAMLISTING_TAG);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.markup(this.horizontalRuleElement);
    }

    public void pageBreak() {
        this.markup(this.pageBreakElement);
    }

    public void figure() {
        this.writeStartTag(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG);
    }

    public void figure_() {
        this.writeEndTag(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG);
    }

    protected void graphicElement() {
        if (this.graphicsFileName != null) {
            String format = FileUtils.extension((String)this.graphicsFileName).toUpperCase(Locale.ENGLISH);
            if (format.length() == 0) {
                format = "JPEG";
            }
            this.writeStartTag(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG);
            this.writeStartTag(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG);
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("format", format);
            att.addAttribute("fileref", HtmlTools.escapeHTML((String)this.graphicsFileName, (boolean)true));
            this.writeSimpleTag(SimplifiedDocbookMarkup.IMAGEDATA_TAG, att);
            this.writeEndTag(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG);
            this.writeEndTag(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG);
            this.graphicsFileName = null;
        }
    }

    public void figureGraphics(String name) {
        String format = FileUtils.extension((String)name).toUpperCase(Locale.ENGLISH);
        this.writeStartTag(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG);
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("format", format);
        att.addAttribute("fileref", HtmlTools.escapeHTML((String)name, (boolean)true));
        this.writeSimpleTag(SimplifiedDocbookMarkup.IMAGEDATA_TAG, att);
        this.writeEndTag(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG);
    }

    public void figureCaption() {
        this.writeStartTag(SimplifiedDocbookMarkup.CAPTION_TAG);
        this.writeStartTag(SimplifiedDocbookMarkup.PARA_TAG);
    }

    public void figureCaption_() {
        this.writeEndTag(SimplifiedDocbookMarkup.PARA_TAG);
        this.writeEndTag(SimplifiedDocbookMarkup.CAPTION_TAG);
    }

    public void table() {
        this.tableHasCaption = false;
    }

    public void table_() {
        if (this.tableHasCaption) {
            this.tableHasCaption = false;
            this.out.write(this.tableRows);
            this.writeEndTag(TABLE_TAG);
        } else {
            String frame = "none";
            String sep = "0";
            if (this.tableHasGrid) {
                frame = "all";
                sep = "1";
            }
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("frame", frame);
            att.addAttribute("rowsep", sep);
            att.addAttribute("colsep", sep);
            this.writeStartTag(SimplifiedDocbookMarkup.INFORMALTABLE_TAG, att);
            this.out.write(this.tableRows);
            this.writeEndTag(SimplifiedDocbookMarkup.INFORMALTABLE_TAG);
        }
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableHasGrid = grid;
        this.out.flush();
        this.savedOut = this.out;
        this.tableRowsWriter = new StringWriter();
        this.out = new PrintWriter(this.tableRowsWriter);
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("cols", String.valueOf(justification.length));
        this.writeStartTag(SimplifiedDocbookMarkup.TGROUP_TAG, att);
        for (int i = 0; i < justification.length; ++i) {
            String justif;
            switch (justification[i]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
            att = new SimpleAttributeSet();
            att.addAttribute("align", justif);
            this.writeSimpleTag(SimplifiedDocbookMarkup.COLSPEC_TAG, att);
        }
        this.writeStartTag(SimplifiedDocbookMarkup.TBODY_TAG);
    }

    public void tableRows_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TBODY_TAG);
        this.writeEndTag(SimplifiedDocbookMarkup.TGROUP_TAG);
        this.out.flush();
        if (this.tableRowsWriter == null) {
            throw new IllegalArgumentException("tableRows( int[] justification, boolean grid ) was not called before.");
        }
        this.tableRows = this.tableRowsWriter.toString();
        this.tableRowsWriter = null;
        this.out = this.savedOut;
    }

    public void tableRow() {
        this.writeStartTag(SimplifiedDocbookMarkup.ROW_TAG);
    }

    public void tableRow_() {
        this.writeEndTag(SimplifiedDocbookMarkup.ROW_TAG);
    }

    public void tableCell() {
        this.writeStartTag(SimplifiedDocbookMarkup.ENTRY_TAG);
    }

    public void tableCell_() {
        this.writeEndTag(SimplifiedDocbookMarkup.ENTRY_TAG);
    }

    public void tableHeaderCell() {
        this.writeStartTag(SimplifiedDocbookMarkup.ENTRY_TAG);
    }

    public void tableHeaderCell_() {
        this.writeEndTag(SimplifiedDocbookMarkup.ENTRY_TAG);
    }

    public void tableCaption() {
        int sep;
        String frame;
        this.tableHasCaption = true;
        if (this.tableHasGrid) {
            frame = "all";
            sep = 1;
        } else {
            frame = "none";
            sep = 0;
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("frame", frame);
        att.addAttribute("rowsep", String.valueOf(sep));
        att.addAttribute("colsep", String.valueOf(sep));
        this.writeStartTag(TABLE_TAG, att);
        this.writeStartTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void tableCaption_() {
        this.writeEndTag(SimplifiedDocbookMarkup.TITLE_TAG);
    }

    public void anchor(String name) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        if (this.authorDateFlag) {
            return;
        }
        String id = name;
        if (!DoxiaUtils.isValidId((String)id)) {
            id = DoxiaUtils.encodeId((String)name, (boolean)true);
            String msg = "Modified invalid anchor name: '" + name + "' to '" + id + "'";
            this.logMessage("modifiedLink", msg);
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("id", id);
        this.writeSimpleTag(SimplifiedDocbookMarkup.ANCHOR_TAG, att);
    }

    public void anchor_() {
        this.comment("anchor_end");
    }

    public void link(String name) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isInternalLink((String)name)) {
            String linkend = name.substring(1);
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("linkend", HtmlTools.escapeHTML((String)linkend));
            this.writeStartTag(SimplifiedDocbookMarkup.LINK_TAG, att);
        } else {
            this.externalLinkFlag = true;
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("url", HtmlTools.escapeHTML((String)name, (boolean)true));
            this.writeStartTag(SimplifiedDocbookMarkup.ULINK_TAG, att);
        }
    }

    public void link_() {
        if (this.externalLinkFlag) {
            this.writeEndTag(SimplifiedDocbookMarkup.ULINK_TAG);
            this.externalLinkFlag = false;
        } else {
            this.writeEndTag(SimplifiedDocbookMarkup.LINK_TAG);
        }
    }

    public void italic() {
        this.markup(this.italicBeginTag);
    }

    public void italic_() {
        this.markup(this.italicEndTag);
    }

    public void bold() {
        this.markup(this.boldBeginTag);
    }

    public void bold_() {
        this.markup(this.boldEndTag);
    }

    public void monospaced() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedBeginTag);
        }
    }

    public void monospaced_() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedEndTag);
        }
    }

    public void lineBreak() {
        this.markup(this.lineBreakElement);
    }

    public void nonBreakingSpace() {
        this.markup("&#x00A0;");
    }

    public void text(String text) {
        if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void comment(String comment) {
        if (StringUtils.isNotEmpty((String)comment) && comment.indexOf("--") != -1) {
            String originalComment = comment;
            while (comment.indexOf("--") != -1) {
                comment = StringUtils.replace((String)comment, (String)"--", (String)"- -");
            }
            String msg = "Modified invalid comment: '" + originalComment + "' to '" + comment + "'";
            this.logMessage("modifiedComment", msg);
        }
        StringBuffer buffer = new StringBuffer(comment.length() + 9);
        buffer.append('<').append('!').append('-').append('-').append(' ');
        buffer.append(comment);
        buffer.append(' ').append('-').append('-').append('>');
        this.markup(buffer.toString());
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        String msg = "Unknown Sink event: '" + name + "', ignoring!";
        this.logMessage("unknownEvent", msg);
    }

    protected void markup(String text) {
        if (!this.skip) {
            this.out.write(text);
        }
    }

    protected void content(String text) {
        if (!this.skip) {
            this.out.write(HtmlTools.escapeHTML((String)text, (boolean)true));
        }
    }

    protected void verbatimContent(String text) {
        if (!this.skip) {
            this.out.write(HtmlTools.escapeHTML((String)text, (boolean)true));
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
        if (this.getLog().isWarnEnabled() && this.warnMessages != null) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
            this.warnMessages = null;
        }
    }

    protected void write(String text) {
        this.markup(DocBookSink.unifyEOLs((String)text));
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private void logMessage(String key, String msg) {
        Set<String> set;
        msg = "[Docbook Sink] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }
}

