/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.dozer.util.mapping.DozerBeanMapperSingletonWrapper;
import net.sf.dozer.util.mapping.MapperIF;
import org.apache.maven.continuum.Continuum;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.installation.InstallationException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuildingResult;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.server.AbstractContinuumSecureService;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuumServiceImpl
extends AbstractContinuumSecureService {
    private static MapperIF mapper = DozerBeanMapperSingletonWrapper.getInstance();
    private Continuum continuum;
    private ContinuumStore store;
    private RoleManager roleManager;

    public boolean ping() throws ContinuumException {
        return true;
    }

    public List<ProjectSummary> getProjects(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        ArrayList<ProjectSummary> projectsList = new ArrayList<ProjectSummary>();
        Collection projects = this.continuum.getProjectsInGroup(projectGroupId);
        if (projects != null) {
            for (Project project : projects) {
                ProjectSummary ps = this.populateProjectSummary(project);
                projectsList.add(ps);
            }
        }
        return projectsList;
    }

    public ProjectSummary getProjectSummary(int projectId) throws ContinuumException {
        Project project = this.continuum.getProject(projectId);
        this.checkViewProjectGroupAuthorization(project.getProjectGroup().getName());
        return this.populateProjectSummary(project);
    }

    public org.apache.maven.continuum.xmlrpc.project.Project getProjectWithAllDetails(int projectId) throws ContinuumException {
        Project project = this.continuum.getProjectWithAllDetails(projectId);
        this.checkViewProjectGroupAuthorization(project.getProjectGroup().getName());
        return this.populateProject(project);
    }

    public int removeProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkRemoveProjectFromGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.removeProject(projectId);
        return 0;
    }

    public ProjectSummary updateProject(ProjectSummary project) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(project.getId());
        this.checkRemoveProjectFromGroupAuthorization(ps.getProjectGroup().getName());
        Project p = this.continuum.getProject(project.getId());
        p.setName(project.getName());
        p.setVersion(project.getVersion());
        p.setScmUrl(project.getScmUrl());
        p.setScmUseCache(project.isScmUseCache());
        p.setScmUsername(project.getScmUsername());
        p.setScmPassword(project.getScmPassword());
        p.setScmTag(project.getScmTag());
        this.continuum.updateProject(p);
        return this.getProjectSummary(project.getId());
    }

    public List<ProjectGroupSummary> getAllProjectGroups() throws ContinuumException {
        Collection pgList = this.continuum.getAllProjectGroups();
        ArrayList<ProjectGroupSummary> result = new ArrayList<ProjectGroupSummary>();
        for (org.apache.maven.continuum.model.project.ProjectGroup projectGroup : pgList) {
            try {
                if (!this.isAuthorized("continuum-view-group", projectGroup.getName())) continue;
                result.add(this.populateProjectGroupSummary(projectGroup));
            }
            catch (AuthorizationException e) {
                throw new ContinuumException("error authorizing request.");
            }
        }
        return result;
    }

    public List<ProjectGroup> getAllProjectGroupsWithAllDetails() throws ContinuumException {
        List pgList = this.continuum.getAllProjectGroupsWithBuildDetails();
        ArrayList<ProjectGroup> result = new ArrayList<ProjectGroup>();
        for (org.apache.maven.continuum.model.project.ProjectGroup projectGroup : pgList) {
            try {
                if (!this.isAuthorized("continuum-view-group", projectGroup.getName())) continue;
                result.add(this.populateProjectGroupWithAllDetails(projectGroup));
            }
            catch (AuthorizationException e) {
                throw new ContinuumException("error authorizing request.");
            }
        }
        return result;
    }

    public List<ProjectGroup> getAllProjectGroupsWithProjects() throws ContinuumException {
        return this.getAllProjectGroupsWithAllDetails();
    }

    protected String getProjectGroupName(int projectGroupId) throws ContinuumException {
        ProjectGroupSummary pgs = this.getPGSummary(projectGroupId);
        return pgs.getName();
    }

    private ProjectGroupSummary getPGSummary(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        org.apache.maven.continuum.model.project.ProjectGroup projectGroup = this.continuum.getProjectGroup(projectGroupId);
        return this.populateProjectGroupSummary(projectGroup);
    }

    public ProjectGroupSummary getProjectGroupSummary(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        org.apache.maven.continuum.model.project.ProjectGroup projectGroup = this.continuum.getProjectGroup(projectGroupId);
        return this.populateProjectGroupSummary(projectGroup);
    }

    public ProjectGroup getProjectGroupWithProjects(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        org.apache.maven.continuum.model.project.ProjectGroup projectGroup = this.continuum.getProjectGroupWithProjects(projectGroupId);
        return this.populateProjectGroupWithAllDetails(projectGroup);
    }

    public int removeProjectGroup(int projectGroupId) throws ContinuumException {
        this.checkRemoveProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        this.continuum.removeProjectGroup(projectGroupId);
        return 0;
    }

    public ProjectGroupSummary updateProjectGroup(ProjectGroupSummary projectGroup) throws ContinuumException {
        if (projectGroup == null) {
            return null;
        }
        this.checkModifyProjectGroupAuthorization(this.getProjectGroupName(projectGroup.getId()));
        if (StringUtils.isEmpty((String)projectGroup.getName())) {
            throw new ContinuumException("project group name is required");
        }
        if (StringUtils.isEmpty((String)projectGroup.getName().trim())) {
            throw new ContinuumException("project group name can't be spaces");
        }
        org.apache.maven.continuum.model.project.ProjectGroup pg = this.continuum.getProjectGroupWithProjects(projectGroup.getId());
        if (!projectGroup.getName().equals(pg.getName())) {
            try {
                this.roleManager.updateRole("project-administrator", pg.getName(), projectGroup.getName());
                this.roleManager.updateRole("project-developer", pg.getName(), projectGroup.getName());
                this.roleManager.updateRole("project-user", pg.getName(), projectGroup.getName());
                pg.setName(projectGroup.getName());
            }
            catch (RoleManagerException e) {
                throw new ContinuumException("unable to rename the project group", (Throwable)e);
            }
        }
        pg.setDescription(projectGroup.getDescription());
        this.continuum.updateProjectGroup(pg);
        return this.getProjectGroupSummary(projectGroup.getId());
    }

    public ProjectGroupSummary addProjectGroup(String groupName, String groupId, String description) throws Exception {
        org.apache.maven.continuum.model.project.ProjectGroup pg = new org.apache.maven.continuum.model.project.ProjectGroup();
        pg.setName(groupName);
        pg.setGroupId(groupId);
        pg.setDescription(description);
        this.continuum.addProjectGroup(pg);
        return this.populateProjectGroupSummary(this.continuum.getProjectGroupByGroupId(groupId));
    }

    public List<org.apache.maven.continuum.xmlrpc.project.BuildDefinition> getBuildDefinitionsForProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        List bds = this.continuum.getBuildDefinitionsForProject(projectId);
        ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition> result = new ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition>();
        for (BuildDefinition bd : bds) {
            result.add(this.populateBuildDefinition(bd));
        }
        return result;
    }

    public List<org.apache.maven.continuum.xmlrpc.project.BuildDefinition> getBuildDefinitionsForProjectGroup(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        List bds = this.continuum.getBuildDefinitionsForProjectGroup(projectGroupId);
        ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition> result = new ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition>();
        for (BuildDefinition bd : bds) {
            result.add(this.populateBuildDefinition(bd));
        }
        return result;
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition updateBuildDefinitionForProject(int projectId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkModifyProjectBuildDefinitionAuthorization(ps.getProjectGroup().getName());
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.updateBuildDefinitionForProject(projectId, bd);
        return this.populateBuildDefinition(bd);
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition updateBuildDefinitionForProjectGroup(int projectGroupId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        this.checkModifyGroupBuildDefinitionAuthorization(this.getProjectGroupName(projectGroupId));
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.updateBuildDefinitionForProjectGroup(projectGroupId, bd);
        return this.populateBuildDefinition(bd);
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition addBuildDefinitionToProject(int projectId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        this.checkAddProjectBuildDefinitionAuthorization(this.getProjectSummary(projectId).getProjectGroup().getName());
        if (buildDef.getSchedule() == null) {
            throw new ContinuumException("The schedule can't be null.");
        }
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.addBuildDefinitionToProject(projectId, bd);
        return this.populateBuildDefinition(bd);
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition addBuildDefinitionToProjectGroup(int projectGroupId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        this.checkAddGroupBuildDefinitionAuthorization(this.getPGSummary(projectGroupId).getName());
        if (buildDef.getSchedule() == null) {
            throw new ContinuumException("The schedule can't be null.");
        }
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.addBuildDefinitionToProjectGroup(projectGroupId, bd);
        return this.populateBuildDefinition(bd);
    }

    public List<BuildDefinitionTemplate> getBuildDefinitionTemplates() throws Exception {
        this.checkManageBuildDefinitionTemplatesAuthorization();
        List bdts = this.continuum.getBuildDefinitionService().getAllBuildDefinitionTemplate();
        ArrayList<BuildDefinitionTemplate> result = new ArrayList<BuildDefinitionTemplate>();
        for (org.apache.maven.continuum.model.project.BuildDefinitionTemplate bdt : bdts) {
            result.add(this.populateBuildDefinitionTemplate(bdt));
        }
        return result;
    }

    public int addProjectToBuildQueue(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId, 0);
        return 0;
    }

    public int addProjectToBuildQueue(int projectId, int buildDefinitionId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId, buildDefinitionId, 0);
        return 0;
    }

    public int buildProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId);
        return 0;
    }

    public int buildProject(int projectId, int buildDefintionId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProjectWithBuildDefinition(projectId, buildDefintionId);
        return 0;
    }

    public int buildGroup(int projectGroupId) throws ContinuumException {
        ProjectGroupSummary pg = this.getProjectGroupSummary(projectGroupId);
        this.checkBuildProjectInGroupAuthorization(pg.getName());
        this.continuum.buildProjectGroup(projectGroupId);
        return 0;
    }

    public int buildGroup(int projectGroupId, int buildDefintionId) throws ContinuumException {
        ProjectGroupSummary pg = this.getProjectGroupSummary(projectGroupId);
        this.checkBuildProjectInGroupAuthorization(pg.getName());
        this.continuum.buildProjectGroupWithBuildDefinition(projectGroupId, buildDefintionId);
        return 0;
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildResult getLatestBuildResult(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        BuildResult buildResult = this.continuum.getLatestBuildResultForProject(projectId);
        return this.getBuildResult(projectId, buildResult.getId());
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildResult getBuildResult(int projectId, int buildId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        return this.populateBuildResult(this.continuum.getBuildResult(buildId));
    }

    public List<BuildResultSummary> getBuildResultsForProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        ArrayList<BuildResultSummary> result = new ArrayList<BuildResultSummary>();
        Collection buildResults = this.continuum.getBuildResultsForProject(projectId);
        if (buildResults != null) {
            for (BuildResult buildResult : (List)buildResults) {
                BuildResultSummary br = this.populateBuildResultSummary(buildResult);
                result.add(br);
            }
        }
        return result;
    }

    public int removeBuildResult(org.apache.maven.continuum.xmlrpc.project.BuildResult br) throws ContinuumException {
        this.checkModifyProjectGroupAuthorization(this.getProjectSummary(br.getProject().getId()).getProjectGroup().getName());
        this.continuum.removeBuildResult(br.getId());
        return 0;
    }

    public String getBuildOutput(int projectId, int buildId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        return this.continuum.getBuildOutput(projectId, buildId);
    }

    public AddingResult addMavenTwoProject(String url) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        ContinuumProjectBuildingResult result = this.continuum.addMavenTwoProject(url);
        return this.populateAddingResult(result);
    }

    public AddingResult addMavenTwoProject(String url, int projectGroupId) throws ContinuumException {
        this.checkAddProjectToGroupAuthorization(this.getProjectGroupName(projectGroupId));
        ContinuumProjectBuildingResult result = this.continuum.addMavenTwoProject(url, projectGroupId);
        return this.populateAddingResult(result);
    }

    public AddingResult addMavenOneProject(String url) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        ContinuumProjectBuildingResult result = this.continuum.addMavenOneProject(url);
        return this.populateAddingResult(result);
    }

    public AddingResult addMavenOneProject(String url, int projectGroupId) throws ContinuumException {
        this.checkAddProjectToGroupAuthorization(this.getProjectGroupName(projectGroupId));
        ContinuumProjectBuildingResult result = this.continuum.addMavenOneProject(url, projectGroupId);
        return this.populateAddingResult(result);
    }

    public ProjectSummary addAntProject(ProjectSummary project) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "ant");
        return this.getProjectSummary(projectId);
    }

    public ProjectSummary addAntProject(ProjectSummary project, int projectGroupId) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "ant", projectGroupId);
        return this.getProjectSummary(projectId);
    }

    public ProjectSummary addShellProject(ProjectSummary project) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "shell");
        return this.getProjectSummary(projectId);
    }

    public ProjectSummary addShellProject(ProjectSummary project, int projectGroupId) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "shell", projectGroupId);
        return this.getProjectSummary(projectId);
    }

    public List<Schedule> getSchedules() throws ContinuumException {
        this.checkManageSchedulesAuthorization();
        Collection schedules = this.continuum.getSchedules();
        ArrayList<Schedule> s = new ArrayList<Schedule>();
        for (Object schedule : schedules) {
            s.add(this.populateSchedule((org.apache.maven.continuum.model.project.Schedule)schedule));
        }
        return s;
    }

    public Schedule getSchedule(int scheduleId) throws ContinuumException {
        this.checkManageSchedulesAuthorization();
        return this.populateSchedule(this.continuum.getSchedule(scheduleId));
    }

    public Schedule updateSchedule(Schedule schedule) throws ContinuumException {
        this.checkManageSchedulesAuthorization();
        this.continuum.updateSchedule(this.populateSchedule(schedule));
        return this.populateSchedule(this.continuum.getScheduleByName(schedule.getName()));
    }

    public Schedule addSchedule(Schedule schedule) throws ContinuumException {
        this.checkManageSchedulesAuthorization();
        this.continuum.addSchedule(this.populateSchedule(schedule));
        return this.populateSchedule(this.continuum.getScheduleByName(schedule.getName()));
    }

    public List<org.apache.maven.continuum.xmlrpc.system.Profile> getProfiles() throws ContinuumException {
        this.checkManageProfilesAuthorization();
        List profiles = this.continuum.getProfileService().getAllProfiles();
        ArrayList<org.apache.maven.continuum.xmlrpc.system.Profile> p = new ArrayList<org.apache.maven.continuum.xmlrpc.system.Profile>();
        for (Object profile : profiles) {
            p.add(this.populateProfile((Profile)profile));
        }
        return p;
    }

    public org.apache.maven.continuum.xmlrpc.system.Profile getProfile(int profileId) throws ContinuumException {
        this.checkManageProfilesAuthorization();
        return this.populateProfile(this.continuum.getProfileService().getProfile(profileId));
    }

    public List<Installation> getInstallations() throws ContinuumException {
        this.checkManageInstallationsAuthorization();
        try {
            List installs = this.continuum.getInstallationService().getAllInstallations();
            ArrayList<Installation> i = new ArrayList<Installation>();
            for (org.apache.maven.continuum.model.system.Installation install : installs) {
                i.add(this.populateInstallation(install));
            }
            return i;
        }
        catch (InstallationException e) {
            throw new ContinuumException("Can't load installations", (Throwable)e);
        }
    }

    public Installation getInstallation(int installationId) throws ContinuumException {
        this.checkManageInstallationsAuthorization();
        try {
            org.apache.maven.continuum.model.system.Installation install = this.continuum.getInstallationService().getInstallation(installationId);
            return this.populateInstallation(install);
        }
        catch (InstallationException e) {
            throw new ContinuumException("Can't load installations", (Throwable)e);
        }
    }

    public SystemConfiguration getSystemConfiguration() throws ContinuumException {
        this.checkManageConfigurationAuthorization();
        try {
            org.apache.maven.continuum.model.system.SystemConfiguration sysConf = this.store.getSystemConfiguration();
            return this.populateSystemConfiguration(sysConf);
        }
        catch (ContinuumStoreException e) {
            throw new ContinuumException("Can't get SystemConfiguration.", (Throwable)e);
        }
    }

    private ProjectSummary populateProjectSummary(Project project) {
        return (ProjectSummary)mapper.map((Object)project, ProjectSummary.class);
    }

    private org.apache.maven.continuum.xmlrpc.project.Project populateProject(Project project) {
        return (org.apache.maven.continuum.xmlrpc.project.Project)mapper.map((Object)project, org.apache.maven.continuum.xmlrpc.project.Project.class);
    }

    private Project populateProject(ProjectSummary projectSummary) {
        if (projectSummary == null) {
            return null;
        }
        Project project = new Project();
        project.setArtifactId(projectSummary.getArtifactId());
        project.setBuildNumber(projectSummary.getBuildNumber());
        project.setDescription(projectSummary.getDescription());
        project.setExecutorId(projectSummary.getExecutorId());
        project.setGroupId(projectSummary.getGroupId());
        project.setId(projectSummary.getId());
        project.setLatestBuildId(projectSummary.getLatestBuildId());
        project.setName(projectSummary.getName());
        project.setProjectGroup(this.populateProjectGroupSummary(projectSummary.getProjectGroup()));
        project.setScmTag(projectSummary.getScmTag());
        project.setScmUrl(projectSummary.getScmUrl());
        project.setScmUseCache(projectSummary.isScmUseCache());
        project.setScmUsername(projectSummary.getScmUsername());
        project.setState(projectSummary.getState());
        project.setUrl(projectSummary.getUrl());
        project.setVersion(projectSummary.getVersion());
        project.setWorkingDirectory(projectSummary.getWorkingDirectory());
        return project;
    }

    private ProjectGroupSummary populateProjectGroupSummary(org.apache.maven.continuum.model.project.ProjectGroup group) {
        return (ProjectGroupSummary)mapper.map((Object)group, ProjectGroupSummary.class);
    }

    private org.apache.maven.continuum.model.project.ProjectGroup populateProjectGroupSummary(ProjectGroupSummary group) {
        if (group == null) {
            return null;
        }
        org.apache.maven.continuum.model.project.ProjectGroup g = new org.apache.maven.continuum.model.project.ProjectGroup();
        g.setDescription(group.getDescription());
        g.setGroupId(group.getGroupId());
        g.setId(group.getId());
        g.setName(group.getName());
        return g;
    }

    private ProjectGroup populateProjectGroupWithAllDetails(org.apache.maven.continuum.model.project.ProjectGroup group) {
        return (ProjectGroup)mapper.map((Object)group, ProjectGroup.class);
    }

    private BuildResultSummary populateBuildResultSummary(BuildResult buildResult) {
        return (BuildResultSummary)mapper.map((Object)buildResult, BuildResultSummary.class);
    }

    private org.apache.maven.continuum.xmlrpc.project.BuildResult populateBuildResult(BuildResult buildResult) throws ContinuumException {
        return (org.apache.maven.continuum.xmlrpc.project.BuildResult)mapper.map((Object)buildResult, org.apache.maven.continuum.xmlrpc.project.BuildResult.class);
    }

    private AddingResult populateAddingResult(ContinuumProjectBuildingResult result) {
        if (result == null) {
            return null;
        }
        AddingResult res = new AddingResult();
        if (result.hasErrors()) {
            for (String error : result.getErrors()) {
                res.addError(error);
            }
        }
        if (result.getProjects() != null) {
            for (Project project : result.getProjects()) {
                res.addProject(this.populateProjectSummary(project));
            }
        }
        if (result.getProjectGroups() != null) {
            for (org.apache.maven.continuum.model.project.ProjectGroup projectGroup : result.getProjectGroups()) {
                res.addProjectGroup(this.populateProjectGroupSummary(projectGroup));
            }
        }
        return res;
    }

    private org.apache.maven.continuum.xmlrpc.project.BuildDefinition populateBuildDefinition(BuildDefinition buildDef) {
        return (org.apache.maven.continuum.xmlrpc.project.BuildDefinition)mapper.map((Object)buildDef, org.apache.maven.continuum.xmlrpc.project.BuildDefinition.class);
    }

    private BuildDefinition populateBuildDefinition(org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) {
        if (buildDef == null) {
            return null;
        }
        BuildDefinition bd = new BuildDefinition();
        bd.setArguments(buildDef.getArguments());
        bd.setBuildFile(buildDef.getBuildFile());
        bd.setBuildFresh(buildDef.isBuildFresh());
        bd.setDefaultForProject(buildDef.isDefaultForProject());
        bd.setGoals(buildDef.getGoals());
        bd.setId(buildDef.getId());
        bd.setProfile(this.populateProfile(buildDef.getProfile()));
        bd.setSchedule(this.populateSchedule(buildDef.getSchedule()));
        return bd;
    }

    private BuildDefinitionTemplate populateBuildDefinitionTemplate(org.apache.maven.continuum.model.project.BuildDefinitionTemplate bdt) {
        return (BuildDefinitionTemplate)mapper.map((Object)bdt, BuildDefinitionTemplate.class);
    }

    private org.apache.maven.continuum.model.project.Schedule populateSchedule(Schedule schedule) {
        if (schedule == null) {
            return null;
        }
        org.apache.maven.continuum.model.project.Schedule s = new org.apache.maven.continuum.model.project.Schedule();
        s.setActive(schedule.isActive());
        s.setCronExpression(schedule.getCronExpression());
        s.setDelay(schedule.getDelay());
        s.setDescription(schedule.getDescription());
        s.setId(schedule.getId());
        s.setMaxJobExecutionTime(schedule.getMaxJobExecutionTime());
        s.setName(schedule.getName());
        return s;
    }

    private Schedule populateSchedule(org.apache.maven.continuum.model.project.Schedule schedule) {
        return (Schedule)mapper.map((Object)schedule, Schedule.class);
    }

    private Profile populateProfile(org.apache.maven.continuum.xmlrpc.system.Profile profile) {
        if (profile == null) {
            return null;
        }
        Profile p = new Profile();
        p.setActive(profile.isActive());
        p.setBuilder(this.populateInstallation(profile.getBuilder()));
        p.setBuildWithoutChanges(profile.isBuildWithoutChanges());
        p.setDescription(profile.getDescription());
        if (profile.getEnvironmentVariables() != null) {
            ArrayList<org.apache.maven.continuum.model.system.Installation> envs = new ArrayList<org.apache.maven.continuum.model.system.Installation>();
            for (Installation install : profile.getEnvironmentVariables()) {
                envs.add(this.populateInstallation(install));
            }
            p.setEnvironmentVariables(envs);
        }
        p.setId(profile.getId());
        p.setJdk(this.populateInstallation(profile.getJdk()));
        p.setName(profile.getName());
        p.setScmMode(profile.getScmMode());
        return p;
    }

    private org.apache.maven.continuum.xmlrpc.system.Profile populateProfile(Profile profile) {
        return (org.apache.maven.continuum.xmlrpc.system.Profile)mapper.map((Object)profile, org.apache.maven.continuum.xmlrpc.system.Profile.class);
    }

    private org.apache.maven.continuum.model.system.Installation populateInstallation(Installation install) {
        if (install == null) {
            return null;
        }
        org.apache.maven.continuum.model.system.Installation inst = new org.apache.maven.continuum.model.system.Installation();
        inst.setName(install.getName());
        inst.setType(install.getType());
        inst.setVarName(install.getVarName());
        inst.setVarValue(install.getVarValue());
        return inst;
    }

    private Installation populateInstallation(org.apache.maven.continuum.model.system.Installation install) {
        return (Installation)mapper.map((Object)install, Installation.class);
    }

    private SystemConfiguration populateSystemConfiguration(org.apache.maven.continuum.model.system.SystemConfiguration sysConf) {
        return (SystemConfiguration)mapper.map((Object)sysConf, SystemConfiguration.class);
    }
}

