/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.continuum.xmlrpc.server.ContinuumXmlRpcComponent;
import org.apache.maven.continuum.xmlrpc.server.ContinuumXmlRpcConfig;
import org.apache.maven.continuum.xmlrpc.server.Listener;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class ConfiguredBeanProcessorFactory
implements RequestProcessorFactoryFactory,
Initializable,
Contextualizable {
    private Map xmlrpcComponents;
    private Listener listener;
    private Map componentsMapping = new HashMap();
    PlexusContainer container;

    public void initialize() throws InitializationException {
        for (String key : this.xmlrpcComponents.keySet()) {
            String className = this.xmlrpcComponents.get(key).getClass().getName();
            this.componentsMapping.put(className, key);
        }
    }

    public RequestProcessorFactoryFactory.RequestProcessorFactory getRequestProcessorFactory(final Class cls) throws XmlRpcException {
        return new RequestProcessorFactoryFactory.RequestProcessorFactory(){

            public Object getRequestProcessor(XmlRpcRequest request) throws XmlRpcException {
                Object obj = ConfiguredBeanProcessorFactory.this.getRequestProcessor(cls);
                if (obj instanceof ContinuumXmlRpcComponent) {
                    ContinuumXmlRpcConfig config = (ContinuumXmlRpcConfig)request.getConfig();
                    ((ContinuumXmlRpcComponent)obj).setConfig(config);
                }
                return obj;
            }
        };
    }

    protected Object getRequestProcessor(Class cls) throws XmlRpcException {
        this.listener.getLogger().debug("Load '" + cls.getName() + "' handler.");
        Object obj = null;
        try {
            obj = this.getComponent(cls);
        }
        catch (ComponentLookupException e) {
            this.listener.getLogger().error("Can't load component.", (Throwable)e);
        }
        if (obj == null) {
            throw new XmlRpcException("Handler bean not found for: " + cls);
        }
        return obj;
    }

    private String getComponentKey(Class cls) {
        return (String)this.componentsMapping.get(cls.getName());
    }

    private Object getComponent(Class cls) throws ComponentLookupException {
        String key = this.getComponentKey(cls);
        this.listener.getLogger().debug("load component:");
        return this.container.lookup(ContinuumXmlRpcComponent.class.getName(), key);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

