/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;

public class AddingResult
implements Serializable {
    private List projects;
    private List projectGroups;
    private List errors = new ArrayList();
    private String modelEncoding = "UTF-8";

    public void addProject(ProjectSummary projectSummary) {
        if (!(projectSummary instanceof ProjectSummary)) {
            throw new ClassCastException("AddingResult.addProjects(projectSummary) parameter must be instanceof " + ProjectSummary.class.getName());
        }
        this.getProjects().add(projectSummary);
    }

    public void addProjectGroup(ProjectGroupSummary projectGroupSummary) {
        if (!(projectGroupSummary instanceof ProjectGroupSummary)) {
            throw new ClassCastException("AddingResult.addProjectGroups(projectGroupSummary) parameter must be instanceof " + ProjectGroupSummary.class.getName());
        }
        this.getProjectGroups().add(projectGroupSummary);
    }

    public List getProjectGroups() {
        if (this.projectGroups == null) {
            this.projectGroups = new ArrayList();
        }
        return this.projectGroups;
    }

    public List getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList();
        }
        return this.projects;
    }

    public void removeProject(ProjectSummary projectSummary) {
        if (!(projectSummary instanceof ProjectSummary)) {
            throw new ClassCastException("AddingResult.removeProjects(projectSummary) parameter must be instanceof " + ProjectSummary.class.getName());
        }
        this.getProjects().remove(projectSummary);
    }

    public void removeProjectGroup(ProjectGroupSummary projectGroupSummary) {
        if (!(projectGroupSummary instanceof ProjectGroupSummary)) {
            throw new ClassCastException("AddingResult.removeProjectGroups(projectGroupSummary) parameter must be instanceof " + ProjectGroupSummary.class.getName());
        }
        this.getProjectGroups().remove(projectGroupSummary);
    }

    public void setProjectGroups(List projectGroups) {
        this.projectGroups = projectGroups;
    }

    public void setProjects(List projects) {
        this.projects = projects;
    }

    public void addError(String errorKey) {
        this.errors.add(errorKey);
    }

    public List getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public String getErrorsAsString() {
        if (!this.hasErrors()) {
            return null;
        }
        StringBuffer message = new StringBuffer();
        for (String error : this.errors) {
            message.append(error);
            message.append("\n");
        }
        return message.toString();
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

