/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.client;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.continuum.xmlrpc.client.ContinuumXmlRpcClient;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;

public class SampleClient {
    private static ContinuumXmlRpcClient client;

    public static void main(String[] args) throws Exception {
        client = new ContinuumXmlRpcClient(new URL(args[0]), args[1], args[2]);
        System.out.println("Adding project...");
        AddingResult result = client.addMavenTwoProject("http://svn.codehaus.org/plexus/plexus-utils/trunk/pom.xml");
        if (result.hasErrors()) {
            System.out.println(result.getErrorsAsString());
            return;
        }
        System.out.println("Project Groups added.");
        System.out.println("=====================");
        int projectGroupId = 0;
        for (ProjectGroupSummary pg : result.getProjectGroups()) {
            projectGroupId = pg.getId();
            System.out.println("Id: " + pg.getId());
            System.out.println("Group Id" + pg.getGroupId());
            System.out.println("Name: " + pg.getName());
            System.out.println("Description:" + pg.getDescription());
        }
        System.out.println();
        System.out.println("Projects added.");
        System.out.println("=====================");
        for (ProjectSummary p : result.getProjects()) {
            SampleClient.printProjectSummary(client.getProjectSummary(p.getId()));
        }
        System.out.println();
        System.out.println("Waiting the end of the check out...");
        ProjectSummary ps2 = (ProjectSummary)result.getProjects().get(0);
        while (!"New".equals(client.getProjectStatusAsString(ps2.getState()))) {
            ps2 = client.refreshProjectSummary(ps2);
            System.out.println("State of " + ps2.getName() + "(" + ps2.getId() + "): " + client.getProjectStatusAsString(ps2.getState()));
            Thread.sleep(1000L);
        }
        System.out.println();
        System.out.println("Add the project to the build queue.");
        client.buildProject(ps2.getId());
        while (!"Building".equals(client.getProjectStatusAsString(ps2.getState()))) {
            ps2 = client.refreshProjectSummary(ps2);
            Thread.sleep(1000L);
        }
        System.out.println("Building...");
        String state = "unknown";
        while ("Building".equals(client.getProjectStatusAsString(ps2.getState()))) {
            ps2 = client.refreshProjectSummary(ps2);
            state = client.getProjectStatusAsString(ps2.getState());
            System.out.println("State of " + ps2.getName() + "(" + ps2.getId() + "): " + state);
            Thread.sleep(1000L);
        }
        System.out.println("Build done with state=" + state + ".");
        System.out.println("Build result.");
        System.out.println("=====================");
        SampleClient.printBuildResult(client.getLatestBuildResult(ps2.getId()));
        System.out.println();
        System.out.println("Build output.");
        System.out.println("=====================");
        System.out.println(client.getBuildOutput(ps2.getId(), ps2.getLatestBuildId()));
        System.out.println();
        System.out.println("Projects list.");
        System.out.println("=====================");
        List<ProjectSummary> projects = client.getProjects(projectGroupId);
        for (ProjectSummary ps2 : projects) {
            SampleClient.printProjectSummary(ps2);
            System.out.println();
        }
        System.out.println();
        System.out.println("Remove all projects.");
        System.out.println("=====================");
        for (ProjectSummary ps2 : projects) {
            System.out.println("Removing '" + ps2.getName() + "' - " + ps2.getVersion() + " (" + ps2.getId() + ")'...");
            client.removeProject(ps2.getId());
            System.out.println("Done.");
        }
        System.out.println();
        System.out.println("Remove project group.");
        System.out.println("=====================");
        ProjectGroupSummary pg = client.getProjectGroupSummary(projectGroupId);
        System.out.println("Removing Project Group '" + pg.getName() + "' - " + pg.getGroupId() + " (" + pg.getId() + ")'...");
        client.removeProjectGroup(pg.getId());
        System.out.println("Done.");
    }

    public static void printProjectSummary(ProjectSummary project) {
        System.out.println("Id: " + project.getId());
        System.out.println("Group Id:" + project.getGroupId());
        System.out.println("Artifact Id: " + project.getArtifactId());
        System.out.println("Version: " + project.getVersion());
        System.out.println("Name: " + project.getName());
        System.out.println("Description: " + project.getDescription());
        System.out.println("SCM Url: " + project.getScmUrl());
    }

    public static void printBuildResult(BuildResult result) {
        System.out.println("Id: " + result.getId());
        System.out.println("Project Id: " + result.getProject().getId());
        System.out.println("Build Number: " + result.getBuildNumber());
        System.out.println("Start Time: " + result.getStartTime());
        System.out.println("End Time: " + result.getEndTime());
        System.out.println("State: " + client.getProjectStatusAsString(result.getState()));
        System.out.println("Trigger: " + result.getTrigger());
        System.out.println("Is success: " + result.isSuccess());
        System.out.println("Exit code: " + result.getExitCode());
        System.out.println("Error: " + result.getError());
        if (result.getModifiedDependencies() != null) {
            System.out.println("Modified dependencies:");
            Iterator i = result.getModifiedDependencies().iterator();
            while (i.hasNext()) {
                SampleClient.printDependency((ProjectDependency)i.next());
            }
        }
        if (result.getScmResult() != null) {
            System.out.println("Scm Result:");
            SampleClient.printScmResult(result.getScmResult());
        }
    }

    public static void printDependency(ProjectDependency dep) {
        System.out.println("Group Id: " + dep.getGroupId());
        System.out.println("Artifact Id: " + dep.getArtifactId());
        System.out.println("Version: " + dep.getVersion());
    }

    public static void printScmResult(ScmResult scmResult) {
        System.out.println("Command Line: " + scmResult.getCommandLine());
        System.out.println("Command Output: " + scmResult.getCommandOutput());
        System.out.println("SCM Providr Messqge: " + scmResult.getProviderMessage());
        System.out.println("Is Success: " + scmResult.isSuccess());
        System.out.println("Exception: " + scmResult.getException());
        if (scmResult.getChanges() != null) {
            System.out.println("Changes:");
            Iterator i = scmResult.getChanges().iterator();
            while (i.hasNext()) {
                SampleClient.printChangeSet((ChangeSet)i.next());
            }
        }
        System.out.println(scmResult.getCommandLine());
    }

    public static void printChangeSet(ChangeSet changeSet) {
        System.out.println("Author: " + changeSet.getAuthor());
        System.out.println("Date: " + changeSet.getDateAsDate());
        System.out.println("Comment: " + changeSet.getComment());
        if (changeSet.getFiles() != null) {
            System.out.println("Author: " + changeSet.getFiles());
        }
    }

    public static void printBuildDefinition(BuildDefinition buildDef) {
        System.out.println(buildDef.getId());
        System.out.println(buildDef.getBuildFile());
        System.out.println(buildDef.getArguments());
        System.out.println(buildDef.getGoals());
        System.out.println(buildDef.isBuildFresh());
        System.out.println(buildDef.isDefaultForProject());
    }
}

