/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.client;

import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import org.apache.maven.continuum.xmlrpc.ContinuumService;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.util.ClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuumXmlRpcClient
implements ContinuumService {
    private ContinuumService continuum;
    private static Hashtable statusMap = new Hashtable();

    public ContinuumXmlRpcClient(URL serviceUrl) {
        this(serviceUrl, null, null);
    }

    public ContinuumXmlRpcClient(URL serviceUrl, String login, String password) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl(){

            public boolean isEnabledForExtensions() {
                return true;
            }
        };
        if (login != null) {
            config.setBasicUserName(login);
            config.setBasicPassword(password);
        }
        config.setServerURL(serviceUrl);
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig(config);
        ClientFactory factory = new ClientFactory(client);
        this.continuum = (ContinuumService)factory.newInstance(ContinuumService.class);
    }

    @Override
    public boolean ping() throws Exception {
        return this.continuum.ping();
    }

    @Override
    public List<ProjectSummary> getProjects(int projectGroupId) throws Exception {
        return this.continuum.getProjects(projectGroupId);
    }

    @Override
    public ProjectSummary getProjectSummary(int projectId) throws Exception {
        return this.continuum.getProjectSummary(projectId);
    }

    @Override
    public Project getProjectWithAllDetails(int projectId) throws Exception {
        return this.continuum.getProjectWithAllDetails(projectId);
    }

    @Override
    public int removeProject(int projectId) throws Exception {
        return this.continuum.removeProject(projectId);
    }

    @Override
    public ProjectSummary updateProject(ProjectSummary project) throws Exception {
        return this.continuum.updateProject(project);
    }

    public ProjectSummary refreshProjectSummary(ProjectSummary project) throws Exception {
        if (project == null) {
            return null;
        }
        return this.getProjectSummary(project.getId());
    }

    public Project refreshProjectWithAllDetails(ProjectSummary project) throws Exception {
        if (project == null) {
            return null;
        }
        return this.getProjectWithAllDetails(project.getId());
    }

    @Override
    public List<ProjectGroupSummary> getAllProjectGroups() throws Exception {
        return this.continuum.getAllProjectGroups();
    }

    @Override
    public List<ProjectGroup> getAllProjectGroupsWithAllDetails() throws Exception {
        return this.continuum.getAllProjectGroupsWithAllDetails();
    }

    @Override
    public List<ProjectGroup> getAllProjectGroupsWithProjects() throws Exception {
        return this.getAllProjectGroupsWithAllDetails();
    }

    @Override
    public ProjectGroupSummary getProjectGroupSummary(int projectGroupId) throws Exception {
        return this.continuum.getProjectGroupSummary(projectGroupId);
    }

    @Override
    public ProjectGroup getProjectGroupWithProjects(int projectGroupId) throws Exception {
        return this.continuum.getProjectGroupWithProjects(projectGroupId);
    }

    @Override
    public int removeProjectGroup(int projectGroupId) throws Exception {
        return this.continuum.removeProjectGroup(projectGroupId);
    }

    public ProjectGroupSummary refreshProjectGroupSummary(ProjectGroupSummary projectGroup) throws Exception {
        if (projectGroup == null) {
            return null;
        }
        return this.getProjectGroupSummary(projectGroup.getId());
    }

    public ProjectGroup refreshProjectGroupSummaryWithProjects(ProjectGroupSummary projectGroup) throws Exception {
        if (projectGroup == null) {
            return null;
        }
        return this.getProjectGroupWithProjects(projectGroup.getId());
    }

    @Override
    public ProjectGroupSummary updateProjectGroup(ProjectGroupSummary projectGroup) throws Exception {
        return this.continuum.updateProjectGroup(projectGroup);
    }

    public ProjectGroupSummary addProjectGroup(ProjectGroupSummary pg) throws Exception {
        return this.addProjectGroup(pg.getName(), pg.getGroupId(), pg.getDescription());
    }

    @Override
    public ProjectGroupSummary addProjectGroup(String groupName, String groupId, String description) throws Exception {
        return this.continuum.addProjectGroup(groupName, groupId, description);
    }

    @Override
    public List<BuildDefinition> getBuildDefinitionsForProject(int projectId) throws Exception {
        return this.continuum.getBuildDefinitionsForProject(projectId);
    }

    @Override
    public List<BuildDefinition> getBuildDefinitionsForProjectGroup(int projectGroupId) throws Exception {
        return this.continuum.getBuildDefinitionsForProjectGroup(projectGroupId);
    }

    @Override
    public BuildDefinition updateBuildDefinitionForProject(int projectId, BuildDefinition buildDef) throws Exception {
        return this.continuum.updateBuildDefinitionForProject(projectId, buildDef);
    }

    @Override
    public BuildDefinition updateBuildDefinitionForProjectGroup(int projectGroupId, BuildDefinition buildDef) throws Exception {
        return this.continuum.updateBuildDefinitionForProjectGroup(projectGroupId, buildDef);
    }

    @Override
    public BuildDefinition addBuildDefinitionToProject(int projectId, BuildDefinition buildDef) throws Exception {
        return this.continuum.addBuildDefinitionToProject(projectId, buildDef);
    }

    @Override
    public BuildDefinition addBuildDefinitionToProjectGroup(int projectGroupId, BuildDefinition buildDef) throws Exception {
        return this.continuum.addBuildDefinitionToProjectGroup(projectGroupId, buildDef);
    }

    @Override
    public List<BuildDefinitionTemplate> getBuildDefinitionTemplates() throws Exception {
        return this.continuum.getBuildDefinitionTemplates();
    }

    @Override
    public int addProjectToBuildQueue(int projectId) throws Exception {
        return this.continuum.addProjectToBuildQueue(projectId);
    }

    @Override
    public int addProjectToBuildQueue(int projectId, int buildDefinitionId) throws Exception {
        return this.continuum.addProjectToBuildQueue(projectId, buildDefinitionId);
    }

    @Override
    public int buildProject(int projectId) throws Exception {
        return this.continuum.buildProject(projectId);
    }

    @Override
    public int buildProject(int projectId, int buildDefinitionId) throws Exception {
        return this.continuum.buildProject(projectId, buildDefinitionId);
    }

    @Override
    public int buildGroup(int projectGroupId) throws Exception, XmlRpcException {
        return this.continuum.buildGroup(projectGroupId);
    }

    @Override
    public int buildGroup(int projectGroupId, int buildDefinitionId) throws Exception, XmlRpcException {
        return this.continuum.buildGroup(projectGroupId, buildDefinitionId);
    }

    @Override
    public BuildResult getLatestBuildResult(int projectId) throws Exception {
        return this.continuum.getLatestBuildResult(projectId);
    }

    @Override
    public BuildResult getBuildResult(int projectId, int buildId) throws Exception {
        return this.continuum.getBuildResult(projectId, buildId);
    }

    @Override
    public List<BuildResultSummary> getBuildResultsForProject(int projectId) throws Exception {
        return this.continuum.getBuildResultsForProject(projectId);
    }

    @Override
    public int removeBuildResult(BuildResult br) throws Exception, XmlRpcException {
        return this.continuum.removeBuildResult(br);
    }

    @Override
    public String getBuildOutput(int projectId, int buildId) throws Exception {
        return this.continuum.getBuildOutput(projectId, buildId);
    }

    @Override
    public AddingResult addMavenTwoProject(String url) throws Exception {
        return this.continuum.addMavenTwoProject(url);
    }

    @Override
    public AddingResult addMavenTwoProject(String url, int projectGroupId) throws Exception {
        return this.continuum.addMavenTwoProject(url, projectGroupId);
    }

    @Override
    public AddingResult addMavenOneProject(String url) throws Exception {
        return this.continuum.addMavenOneProject(url);
    }

    @Override
    public AddingResult addMavenOneProject(String url, int projectGroupId) throws Exception {
        return this.continuum.addMavenOneProject(url, projectGroupId);
    }

    @Override
    public ProjectSummary addAntProject(ProjectSummary project) throws Exception {
        return this.continuum.addAntProject(project);
    }

    @Override
    public ProjectSummary addAntProject(ProjectSummary project, int projectGroupId) throws Exception {
        return this.continuum.addAntProject(project, projectGroupId);
    }

    @Override
    public ProjectSummary addShellProject(ProjectSummary project) throws Exception {
        return this.continuum.addShellProject(project);
    }

    @Override
    public ProjectSummary addShellProject(ProjectSummary project, int projectGroupId) throws Exception {
        return this.continuum.addShellProject(project, projectGroupId);
    }

    @Override
    public List<Schedule> getSchedules() throws Exception {
        return this.continuum.getSchedules();
    }

    @Override
    public Schedule getSchedule(int scheduleId) throws Exception {
        return this.continuum.getSchedule(scheduleId);
    }

    @Override
    public Schedule addSchedule(Schedule schedule) throws Exception {
        return this.continuum.addSchedule(schedule);
    }

    @Override
    public Schedule updateSchedule(Schedule schedule) throws Exception {
        return this.continuum.updateSchedule(schedule);
    }

    @Override
    public List<Profile> getProfiles() throws Exception {
        return this.continuum.getProfiles();
    }

    @Override
    public Profile getProfile(int profileId) throws Exception {
        return this.continuum.getProfile(profileId);
    }

    @Override
    public List<Installation> getInstallations() throws Exception {
        return this.continuum.getInstallations();
    }

    @Override
    public Installation getInstallation(int installationId) throws Exception {
        return this.continuum.getInstallation(installationId);
    }

    @Override
    public SystemConfiguration getSystemConfiguration() throws Exception {
        return this.continuum.getSystemConfiguration();
    }

    public String getProjectStatusAsString(int status) {
        return (String)statusMap.get(new Integer(status));
    }

    static {
        statusMap.put(new Integer(1), "New");
        statusMap.put(new Integer(10), "New");
        statusMap.put(new Integer(2), "OK");
        statusMap.put(new Integer(3), "Failed");
        statusMap.put(new Integer(4), "Error");
        statusMap.put(new Integer(6), "Building");
        statusMap.put(new Integer(7), "Checking out");
        statusMap.put(new Integer(8), "Updating");
        statusMap.put(new Integer(9), "Warning");
    }
}

