/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.backup;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.continuum.xmlrpc.client.ContinuumXmlRpcClient;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Backup {
    private static final Logger LOGGER = Logger.getLogger(Backup.class);
    private static ContinuumXmlRpcClient client;
    private static int indent;
    private static PrintWriter writer;

    public static void main(String[] args) throws Exception {
        Commands command = new Commands();
        try {
            Args.parse(command, args);
            if (command.help) {
                Args.usage(command);
                return;
            }
            if (command.version) {
                System.out.println("continuum-xmlrpc-backup version: " + Backup.getVersion());
                return;
            }
            if (command.url == null) {
                System.out.println("You must specified the Continuum XMLRPC URL");
                Args.usage(command);
                return;
            }
            if (command.username == null) {
                System.out.println("You must specified the Continuum username");
                Args.usage(command);
                return;
            }
            if (command.password == null) {
                System.out.println("You must specified the Continuum password");
                Args.usage(command);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage(command);
            return;
        }
        BasicConfigurator.configure();
        if (command.debug) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        LOGGER.info("Connection to " + command.url + "with username '" + command.username + "'...");
        client = new ContinuumXmlRpcClient(command.url, command.username, command.password);
        LOGGER.info("connected");
        File out = command.outputFile;
        if (out == null) {
            out = new File("backup/builds.xml");
        }
        out.getParentFile().mkdirs();
        if (!command.overwrite && out.exists()) {
            System.err.println(out.getAbsolutePath() + " already exists and will not be overwritten unless the -overwrite flag is used.");
            Args.usage(command);
            return;
        }
        writer = new PrintWriter(new FileWriter(out));
        writer.println("<?xml version='1.0' encoding='UTF-8'?>");
        Backup.startTag("continuumDatabase", true);
        Backup.backupSystemConfiguration();
        Backup.backupAllSchedules();
        Backup.backupAllInstallations();
        Backup.backupAllProfiles();
        Backup.backupAllBuildDefinitionTemplates();
        Backup.backupAllProjectGroup();
        Backup.endTag("continuumDatabase", true);
        writer.close();
        LOGGER.info("Done.");
    }

    private static String getVersion() throws IOException {
        Properties properties = new Properties();
        properties.load(Backup.class.getResourceAsStream("/META-INF/maven/org.apache.maven.continuum/continuum-xmlrpc-backup/pom.properties"));
        return properties.getProperty("version");
    }

    private static void backupSystemConfiguration() throws Exception {
        LOGGER.info("Backup system configuration");
        Backup.writeObject(client.getSystemConfiguration(), "systemConfiguration", true);
    }

    private static void backupAllSchedules() throws Exception {
        LOGGER.info("Backup schedules");
        List<Schedule> schedules = client.getSchedules();
        if (schedules != null && !schedules.isEmpty()) {
            Backup.startTag("schedules", true);
            for (Schedule schedule : schedules) {
                LOGGER.debug("Backup schedule " + schedule.getName());
                Backup.writeObject(schedule, "schedule", true);
            }
            Backup.endTag("schedules", true);
        }
    }

    private static void backupAllInstallations() throws Exception {
        LOGGER.info("Backup installations");
        List<Installation> installs = client.getInstallations();
        if (installs != null && !installs.isEmpty()) {
            Backup.startTag("installations", true);
            for (Installation install : installs) {
                LOGGER.debug("Backup installation " + install.getName());
                Backup.writeObject(install, "installation", true);
            }
            Backup.endTag("installations", true);
        }
    }

    private static void backupAllBuildDefinitionTemplates() throws Exception {
        LOGGER.info("Backup Build Definitions Templates");
        List<BuildDefinitionTemplate> bdts = client.getBuildDefinitionTemplates();
        if (bdts != null && !bdts.isEmpty()) {
            Backup.startTag("buildDefinitionTemplates", true);
            for (BuildDefinitionTemplate bdt : bdts) {
                LOGGER.debug("Backup build definition template " + bdt.getName());
                Backup.startTag("buildDefinitionTemplate", true);
                Backup.writeSimpleFields(bdt);
                List bds = bdt.getBuildDefinitions();
                if (bds != null && !bds.isEmpty()) {
                    for (BuildDefinition bd : bds) {
                        Backup.backupBuildDefinition(bd);
                    }
                }
                Backup.endTag("buildDefinitionTemplate", true);
            }
            Backup.endTag("buildDefinitionTemplates", true);
        }
    }

    private static void backupAllProfiles() throws Exception {
        LOGGER.info("Backup profiles");
        List<Profile> profiles = client.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            Backup.startTag("profiles", true);
            for (Profile p : profiles) {
                LOGGER.debug("Backup profile " + p.getName());
                Backup.writeProfile(p);
            }
            Backup.endTag("profiles", true);
        }
    }

    private static void backupAllProjectGroup() throws Exception {
        LOGGER.info("Backup project groups");
        List<ProjectGroup> pgs = client.getAllProjectGroupsWithAllDetails();
        if (pgs != null && !pgs.isEmpty()) {
            Backup.startTag("projectGroups", true);
            for (ProjectGroup pg : pgs) {
                Backup.backupProjectGroup(pg);
            }
            Backup.endTag("projectGroups", true);
        }
    }

    private static void backupProjectGroup(ProjectGroup pg) throws Exception {
        if (pg == null) {
            return;
        }
        LOGGER.debug("Backup project group " + pg.getName());
        Backup.startTag("projectGroup", true);
        Backup.writeSimpleFields(pg);
        if (pg.getProjects() != null && !pg.getProjects().isEmpty()) {
            Backup.startTag("projects", true);
            for (ProjectSummary ps : pg.getProjects()) {
                Backup.backupProject(ps);
            }
            Backup.endTag("projects", true);
        }
        if (pg.getBuildDefinitions() != null && !pg.getBuildDefinitions().isEmpty()) {
            Backup.startTag("buildDefinitions", true);
            for (BuildDefinition bd : pg.getBuildDefinitions()) {
                Backup.backupBuildDefinition(bd);
            }
            Backup.endTag("buildDefinitions", true);
        }
        if (pg.getNotifiers() != null && !pg.getNotifiers().isEmpty()) {
            Backup.startTag("notifiers", true);
            for (ProjectNotifier notif : pg.getNotifiers()) {
                Backup.backupNotifier(notif);
            }
            Backup.endTag("notifiers", true);
        }
        Backup.endTag("projectGroup", true);
    }

    private static void backupProject(ProjectSummary ps) throws Exception {
        List<BuildResultSummary> brs;
        if (ps == null) {
            return;
        }
        LOGGER.debug("Backup project " + ps.getName());
        Project p = client.getProjectWithAllDetails(ps.getId());
        Backup.startTag("project", true);
        Backup.writeSimpleFields(p);
        if (p.getProjectGroup() != null) {
            Backup.writeTagWithParameter("projectGroup", "id", String.valueOf(p.getProjectGroup().getId()));
        }
        if (p.getDevelopers() != null && !p.getDevelopers().isEmpty()) {
            Backup.startTag("developers", true);
            for (Serializable pd : p.getDevelopers()) {
                Backup.writeObject(pd, "developer", true);
            }
            Backup.endTag("developers", true);
        }
        if (p.getDependencies() != null && !p.getDependencies().isEmpty()) {
            Backup.startTag("dependencies", true);
            for (Serializable pd : p.getDependencies()) {
                Backup.writeObject(pd, "dependency", true);
            }
            Backup.endTag("dependencies", true);
        }
        if (p.getBuildDefinitions() != null && !p.getBuildDefinitions().isEmpty()) {
            Backup.startTag("buildDefinitions", true);
            for (BuildDefinition bd : p.getBuildDefinitions()) {
                Backup.backupBuildDefinition(bd);
            }
            Backup.endTag("buildDefinitions", true);
        }
        if (p.getNotifiers() != null && !p.getNotifiers().isEmpty()) {
            Backup.startTag("notifiers", true);
            for (ProjectNotifier notif : p.getNotifiers()) {
                Backup.backupNotifier(notif);
            }
            Backup.endTag("notifiers", true);
        }
        if ((brs = client.getBuildResultsForProject(p.getId())) != null && !brs.isEmpty()) {
            Backup.startTag("buildResults", true);
            for (BuildResultSummary brSummary : brs) {
                BuildResult br = client.getBuildResult(p.getId(), brSummary.getId());
                Backup.backupBuildResult(br);
            }
            Backup.endTag("buildResults", true);
        }
        Backup.endTag("project", true);
    }

    private static void backupBuildResult(BuildResult br) throws Exception {
        if (br == null) {
            return;
        }
        Backup.startTag("buildResult", true);
        Backup.writeSimpleFields(br);
        if (br.getProject() != null) {
            Backup.writeTagWithParameter("project", "id", String.valueOf(br.getProject().getId()));
        }
        if (br.getBuildDefinition() != null) {
            Backup.writeTagWithParameter("buildDefinition", "id", String.valueOf(br.getBuildDefinition().getId()));
        }
        if (br.getModifiedDependencies() != null && !br.getModifiedDependencies().isEmpty()) {
            Backup.startTag("dependencies", true);
            for (ProjectDependency pd : br.getModifiedDependencies()) {
                Backup.writeObject(pd, "dependency", true);
            }
            Backup.endTag("dependencies", true);
        }
        Backup.endTag("buildResult", true);
    }

    private static void writeSimpleFields(Object obj) throws Exception {
        if (obj == null) {
            return;
        }
        for (Field f : Backup.getFieldsIncludingSuperclasses(obj.getClass())) {
            if ("modelEncoding".equals(f.getName())) continue;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            if (f.getType().getName().equals("int") || f.getType().getName().equals("long") || f.getType().getName().equals("boolean") || f.getType().getName().equals("java.lang.String")) {
                Object value = f.get(obj);
                if (value == null) continue;
                Backup.startTag(f.getName(), false);
                writer.print(value);
                Backup.endTag(f.getName(), false);
                continue;
            }
            if (ScmResult.class.getName().equals(f.getType().getName())) {
                Backup.writeScmResult((ScmResult)f.get(obj));
                continue;
            }
            if (ChangeFile.class.getName().equals(f.getType().getName())) {
                Backup.writeObject(f.get(obj), "changeFile", true);
                continue;
            }
            if (Profile.class.getName().equals(f.getType().getName())) {
                Backup.writeProfile((Profile)f.get(obj));
                continue;
            }
            LOGGER.debug("Rejected: (" + f.getName() + ") " + f.getType() + " in object " + obj.getClass().getName());
        }
    }

    private static void writeObject(Object obj, String tagName, boolean addNewLine) throws Exception {
        if (obj == null) {
            return;
        }
        Backup.startTag(tagName, addNewLine);
        Backup.writeSimpleFields(obj);
        Backup.endTag(tagName, addNewLine);
    }

    private static void backupBuildDefinition(BuildDefinition buildDef) throws Exception {
        if (buildDef == null) {
            return;
        }
        Backup.startTag("buildDefinition", true);
        Backup.writeSimpleFields(buildDef);
        if (buildDef.getSchedule() != null) {
            Backup.writeTagWithParameter("schedule", "id", String.valueOf(buildDef.getSchedule().getId()));
        }
        Backup.endTag("buildDefinition", true);
    }

    private static void backupNotifier(ProjectNotifier notifier) throws Exception {
        Backup.startTag("notifier", true);
        Backup.writeSimpleFields(notifier);
        Map conf = notifier.getConfiguration();
        Backup.startTag("configuration", true);
        for (String key : conf.keySet()) {
            Backup.startTag(key, false);
            writer.print(conf.get(key));
            Backup.endTag(key, false);
        }
        Backup.endTag("configuration", true);
        Backup.endTag("notifier", true);
    }

    private static void writeProfile(Profile profile) throws Exception {
        if (profile == null) {
            return;
        }
        Backup.startTag("profile", true);
        Backup.writeSimpleFields(profile);
        if (profile.getEnvironmentVariables() != null && !profile.getEnvironmentVariables().isEmpty()) {
            Backup.startTag("environmentVariables", true);
            for (Installation env : profile.getEnvironmentVariables()) {
                Backup.writeTagWithParameter("environmentVariable", "installationId", String.valueOf(env.getInstallationId()));
            }
            Backup.endTag("environmentVariables", true);
        }
        if (profile.getJdk() != null) {
            Backup.writeTagWithParameter("jdk", "installationId", String.valueOf(profile.getJdk().getInstallationId()));
        }
        if (profile.getBuilder() != null) {
            Backup.writeTagWithParameter("builder", "installationId", String.valueOf(profile.getBuilder().getInstallationId()));
        }
        Backup.endTag("profile", true);
    }

    private static void writeScmResult(ScmResult scmResult) throws Exception {
        if (scmResult == null) {
            return;
        }
        Backup.startTag("scmResult", true);
        Backup.writeSimpleFields(scmResult);
        if (scmResult.getChanges() != null && !scmResult.getChanges().isEmpty()) {
            Backup.startTag("changeSets", true);
            for (ChangeSet cs : scmResult.getChanges()) {
                Backup.writeObject(cs, "changeSet", true);
            }
            Backup.endTag("changeSets", true);
        }
        Backup.endTag("scmResult", true);
    }

    private static void startTag(String tagName, boolean addNewLineAfter) {
        writer.print(Backup.getIndent());
        writer.print("<");
        writer.print(tagName);
        writer.print(">");
        if (addNewLineAfter) {
            writer.println();
            ++indent;
        }
    }

    private static void endTag(String tagName, boolean isOnNewLine) {
        if (isOnNewLine) {
            --indent;
            writer.print(Backup.getIndent());
        }
        writer.print("</");
        writer.print(tagName);
        writer.println(">");
    }

    private static void writeTagWithParameter(String tagName, String parameterName, String parameterValue) {
        writer.print(Backup.getIndent());
        writer.print("<");
        writer.print(tagName);
        writer.print(" ");
        writer.print(parameterName);
        writer.print("=\"");
        writer.print(parameterValue);
        writer.print("\"></");
        writer.print(tagName);
        writer.println(">");
    }

    private static String getIndent() {
        String result = "";
        for (int i = 0; i < indent; ++i) {
            result = result + "  ";
        }
        return result;
    }

    private static List<Field> getFieldsIncludingSuperclasses(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            fields.addAll(Backup.getFieldsIncludingSuperclasses(superclass));
        }
        return fields;
    }

    static {
        indent = 0;
    }

    private static class Commands {
        @Argument(description="Display help information", value="help", alias="h")
        private boolean help;
        @Argument(description="Display version information", value="version", alias="v")
        private boolean version;
        @Argument(description="Continuum XMLRPC URL", value="url")
        private URL url;
        @Argument(description="Username", value="username", alias="u")
        private String username;
        @Argument(description="Password", value="password", alias="p")
        private String password;
        @Argument(description="Backup file", value="outputFile", alias="o")
        private File outputFile;
        @Argument(description="Whether to overwrite the designated backup file if it already exists in export mode. Default is false.", value="overwrite")
        private boolean overwrite;
        @Argument(description="Turn on debugging information. Default is off.", value="debug")
        private boolean debug;

        private Commands() {
        }
    }
}

