/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.tool;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTool {
    public static final String DEFAULT_FORMAT = "default";
    static /* synthetic */ Class class$java$util$Calendar;

    public static final Date getSystemDate() {
        return DateTool.getSystemCalendar().getTime();
    }

    public static final Calendar getSystemCalendar() {
        return Calendar.getInstance();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.getTimeZone(), this.getLocale());
    }

    public String getFormat() {
        return DEFAULT_FORMAT;
    }

    public Integer getYear() {
        return this.getYear(this.getCalendar());
    }

    public Integer getYear(Object date) {
        return this.getValue(1, date);
    }

    public Integer getMonth() {
        return this.getMonth(this.getCalendar());
    }

    public Integer getMonth(Object date) {
        return this.getValue(2, date);
    }

    public Integer getDay() {
        return this.getDay(this.getCalendar());
    }

    public Integer getDay(Object date) {
        return this.getValue(5, date);
    }

    public Integer getValue(Object field) {
        return this.getValue(field, (Object)this.getCalendar());
    }

    public Integer getValue(Object field, Object date) {
        int fieldValue;
        if (field == null) {
            return null;
        }
        if (field instanceof Integer) {
            int n = (Integer)field;
        }
        String fstr = field.toString().toUpperCase();
        try {
            Field clsf = (class$java$util$Calendar == null ? (class$java$util$Calendar = DateTool.class$("java.util.Calendar")) : class$java$util$Calendar).getField(fstr);
            fieldValue = clsf.getInt(Calendar.getInstance());
        }
        catch (Exception e) {
            return null;
        }
        return this.getValue(fieldValue, date);
    }

    public Integer getValue(int field, Object date) {
        Calendar cal = this.toCalendar(date);
        if (cal == null) {
            return null;
        }
        return new Integer(cal.get(field));
    }

    public String get(String format) {
        return this.format(format, this.getDate());
    }

    public String get(String dateStyle, String timeStyle) {
        return this.format(dateStyle, timeStyle, this.getDate(), this.getLocale());
    }

    public String format(Object obj) {
        return this.format(this.getFormat(), obj);
    }

    public String format(String format, Object obj) {
        return this.format(format, obj, this.getLocale());
    }

    public String format(String format, Object obj, Locale locale) {
        return this.format(format, obj, locale, this.getTimeZone());
    }

    public String format(String format, Object obj, Locale locale, TimeZone timezone) {
        Date date = this.toDate(obj);
        DateFormat df = this.getDateFormat(format, locale, timezone);
        if (date == null || df == null) {
            return null;
        }
        return df.format(date);
    }

    public String format(String dateStyle, String timeStyle, Object obj) {
        return this.format(dateStyle, timeStyle, obj, this.getLocale());
    }

    public String format(String dateStyle, String timeStyle, Object obj, Locale locale) {
        return this.format(dateStyle, timeStyle, obj, locale, this.getTimeZone());
    }

    public String format(String dateStyle, String timeStyle, Object obj, Locale locale, TimeZone timezone) {
        Date date = this.toDate(obj);
        DateFormat df = this.getDateFormat(dateStyle, timeStyle, locale, timezone);
        if (date == null || df == null) {
            return null;
        }
        return df.format(date);
    }

    public DateFormat getDateFormat(String format, Locale locale, TimeZone timezone) {
        if (format == null) {
            return null;
        }
        DateFormat df = null;
        if (format.endsWith("_date")) {
            String fmt = format.substring(0, format.length() - 5);
            int style = this.getStyleAsInt(fmt);
            df = this.getDateFormat(style, -1, locale, timezone);
        } else if (format.endsWith("_time")) {
            String fmt = format.substring(0, format.length() - 5);
            int style = this.getStyleAsInt(fmt);
            df = this.getDateFormat(-1, style, locale, timezone);
        } else {
            int style = this.getStyleAsInt(format);
            if (style < 0) {
                df = new SimpleDateFormat(format, locale);
                df.setTimeZone(timezone);
            } else {
                df = this.getDateFormat(style, style, locale, timezone);
            }
        }
        return df;
    }

    public DateFormat getDateFormat(String dateStyle, String timeStyle, Locale locale, TimeZone timezone) {
        int ds = this.getStyleAsInt(dateStyle);
        int ts = this.getStyleAsInt(timeStyle);
        return this.getDateFormat(ds, ts, locale, timezone);
    }

    protected DateFormat getDateFormat(int dateStyle, int timeStyle, Locale locale, TimeZone timezone) {
        try {
            DateFormat df = dateStyle < 0 && timeStyle < 0 ? DateFormat.getInstance() : (timeStyle < 0 ? DateFormat.getDateInstance(dateStyle, locale) : (dateStyle < 0 ? DateFormat.getTimeInstance(timeStyle, locale) : DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale)));
            df.setTimeZone(timezone);
            return df;
        }
        catch (Exception suppressed) {
            return null;
        }
    }

    protected int getStyleAsInt(String style) {
        if (style == null || style.length() < 4 || style.length() > 7) {
            return -1;
        }
        if (style.equalsIgnoreCase("full")) {
            return 0;
        }
        if (style.equalsIgnoreCase("long")) {
            return 1;
        }
        if (style.equalsIgnoreCase("medium")) {
            return 2;
        }
        if (style.equalsIgnoreCase("short")) {
            return 3;
        }
        if (style.equalsIgnoreCase(DEFAULT_FORMAT)) {
            return 2;
        }
        return -1;
    }

    public Date toDate(Object obj) {
        return this.toDate(this.getFormat(), obj, this.getLocale(), this.getTimeZone());
    }

    public Date toDate(String format, Object obj) {
        return this.toDate(format, obj, this.getLocale(), this.getTimeZone());
    }

    public Date toDate(String format, Object obj, Locale locale) {
        return this.toDate(format, obj, locale, this.getTimeZone());
    }

    public Date toDate(String format, Object obj, Locale locale, TimeZone timezone) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (obj instanceof Number) {
            Date d = new Date();
            d.setTime(((Number)obj).longValue());
            return d;
        }
        try {
            DateFormat parser = this.getDateFormat(format, locale, timezone);
            return parser.parse(String.valueOf(obj));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Calendar toCalendar(Object obj) {
        return this.toCalendar(obj, this.getLocale());
    }

    public Calendar toCalendar(Object obj, Locale locale) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Calendar) {
            return (Calendar)obj;
        }
        Date date = this.toDate(obj);
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(date);
        cal.getTime();
        return cal;
    }

    public String toString() {
        return this.format(this.getFormat(), this.getDate());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

