/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.maven.continuum.web.context.Scalar;
import org.apache.maven.continuum.web.context.View;
import org.apache.maven.continuum.web.context.ViewContextPopulator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public class DefaultViewContextPopulator
extends AbstractLogEnabled
implements ViewContextPopulator,
Initializable {
    private List views;
    private Map viewMap;

    public Map getScalars(String viewId, Object model, Map parameters) {
        View view = (View)this.viewMap.get(viewId);
        HashMap<String, Object> contextScalars = new HashMap<String, Object>();
        if (view != null) {
            Iterator i = view.getScalars().iterator();
            while (i.hasNext()) {
                Scalar scalar = (Scalar)i.next();
                try {
                    Object value = Ognl.getValue((String)scalar.getExpression(), (Map)parameters, (Object)model);
                    contextScalars.put(scalar.getId(), value);
                }
                catch (OgnlException e) {
                    contextScalars.put(scalar.getId(), scalar.getExpression());
                    this.getLogger().warn("Cannot find a value for the expression " + scalar.getExpression() + "in " + model);
                }
            }
        }
        return contextScalars;
    }

    public void initialize() {
        this.viewMap = new HashMap();
        Iterator i = this.views.iterator();
        while (i.hasNext()) {
            View view = (View)i.next();
            this.viewMap.put(view.getId(), view);
        }
    }
}

