/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.servlet;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.utils.PlexusContainerManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;

public class DownloadServlet
extends HttpServlet {
    private static final int BUFSIZE = 2048;
    private PlexusContainer container;
    private Logger logger;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.container = PlexusContainerManager.getInstance().getContainer();
        this.logger = this.container.getLogger();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String fileName = req.getParameter("file");
        if (StringUtils.isEmpty((String)fileName)) {
            res.sendError(500, "You must specified the 'file' parameter.");
            return;
        }
        File f = null;
        try {
            f = this.getFile(fileName);
        }
        catch (Exception e) {
            this.logger.error("Can't get file " + fileName, (Throwable)e);
        }
        if (f != null && f.exists()) {
            this.doDownload(req, res, f, fileName);
        } else {
            res.sendError(404);
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        String fileName = req.getParameter("file");
        if (StringUtils.isNotEmpty((String)fileName)) {
            try {
                File f = this.getFile(fileName);
                if (f != null && f.exists()) {
                    return f.lastModified();
                }
            }
            catch (Exception e) {
                this.logger.error("Can't get file " + fileName, (Throwable)e);
            }
        }
        return super.getLastModified(req);
    }

    public String getServletInfo() {
        return ((Object)((Object)this)).getClass().getName() + " by Continuum Team";
    }

    private File getFile(String fileName) throws Exception {
        ConfigurationService configuration = (ConfigurationService)this.container.lookup(ConfigurationService.ROLE);
        if ((fileName = this.cleanUrl(fileName)).indexOf("..") >= 0 || fileName.startsWith("/")) {
            throw new IllegalArgumentException("file " + fileName + " isn't allowed.");
        }
        File f = new File(configuration.getWorkingDirectory(), fileName);
        if (f.exists()) {
            return f;
        }
        f = new File(configuration.getBuildOutputDirectory(), fileName);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(HttpServletRequest req, HttpServletResponse response, File file, String fileNameParam) throws IOException {
        File currentFile = file;
        if (currentFile.isDirectory()) {
            File index = new File(file, "index.html");
            if (index.exists()) {
                currentFile = index;
            } else {
                index = new File(file, "index.htm");
                if (index.exists()) {
                    currentFile = index;
                }
            }
        }
        FilterInputStream input = null;
        byte[] bbuf = new byte[2048];
        try {
            String fileName = currentFile.getName();
            ServletOutputStream output = response.getOutputStream();
            ServletContext context = this.getServletConfig().getServletContext();
            if (currentFile.isFile()) {
                int length;
                String mimetype = context.getMimeType(fileName);
                mimetype = mimetype != null ? mimetype : "application/octet-stream";
                response.setContentType(mimetype);
                if (!mimetype.startsWith("text/")) {
                    response.setHeader("Content-Disposition", "attachement; filename=\"" + fileName + "\"");
                }
                input = new DataInputStream(this.getContent(req, response, currentFile, mimetype, fileNameParam));
                while ((length = ((DataInputStream)input).read(bbuf)) != -1) {
                    output.write(bbuf, 0, length);
                }
                output.flush();
            } else {
                response.sendError(403);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    private InputStream getContent(HttpServletRequest req, HttpServletResponse response, File file, String mimetype, String fileNameParam) throws IOException {
        if (!"text/html".equals(mimetype) && !"text/css".equals(mimetype)) {
            response.setContentLength((int)file.length());
            return new FileInputStream(file);
        }
        String content = this.rewriteFileContent(req, file, fileNameParam);
        response.setContentLength(content.length());
        return new StringInputStream(content);
    }

    private String rewriteFileContent(HttpServletRequest req, File file, String fileNameParam) throws IOException {
        String extension = FileUtils.getExtension((String)file.getName());
        String content = FileUtils.fileRead((File)file);
        if ("html".equalsIgnoreCase(extension) || "htm".equalsIgnoreCase(extension)) {
            content = this.rewriteSrcInHtml(req, "img", content, fileNameParam);
            content = this.rewriteSrcInHtml(req, "script", content, fileNameParam);
            content = this.rewriteHrefInHtml(req, "a", content, fileNameParam);
            content = this.rewriteHrefInHtml(req, "link", content, fileNameParam);
            content = this.rewriteImportInHtml(req, content, fileNameParam);
        } else if ("css".equalsIgnoreCase(extension)) {
            content = this.rewriteUrlInCSS(req, content, fileNameParam);
        }
        return content;
    }

    private String rewriteUrlInCSS(HttpServletRequest req, String cssContent, String fileNameParam) {
        int startUrl = cssContent.indexOf("url(");
        if (startUrl < 0) {
            return cssContent;
        }
        int endUrl = cssContent.indexOf(")", startUrl);
        if (endUrl < 0) {
            return cssContent;
        }
        return cssContent.substring(0, startUrl + 4) + this.rewriteUrl(req, cssContent.substring(startUrl + 4, endUrl), fileNameParam) + this.rewriteUrlInCSS(req, cssContent.substring(endUrl), fileNameParam);
    }

    private String rewriteSrcInHtml(HttpServletRequest req, String tagName, String htmlContent, String fileNameParam) {
        int srcPos;
        int startImg = htmlContent.indexOf("<" + tagName + " ");
        if (startImg < 0) {
            return htmlContent;
        }
        int endImg = htmlContent.indexOf(">", startImg);
        if (endImg > (srcPos = htmlContent.indexOf("src=\"", startImg)) && srcPos > 0) {
            int endSrcPos = htmlContent.indexOf("\"", srcPos + 5);
            String url = htmlContent.substring(srcPos + 5, endSrcPos);
            return htmlContent.substring(0, srcPos + 5) + this.rewriteUrl(req, url, fileNameParam) + this.rewriteSrcInHtml(req, tagName, htmlContent.substring(endSrcPos), fileNameParam);
        }
        return htmlContent.substring(0, endImg + 1) + this.rewriteSrcInHtml(req, tagName, htmlContent.substring(endImg), fileNameParam);
    }

    private String rewriteHrefInHtml(HttpServletRequest req, String tagName, String htmlContent, String fileNameParam) {
        int hrefPos;
        int startA = htmlContent.indexOf("<" + tagName + " ");
        if (startA < 0) {
            return htmlContent;
        }
        int endA = htmlContent.indexOf(">", startA);
        if (endA > (hrefPos = htmlContent.indexOf("href=\"", startA)) && hrefPos > 0) {
            int endHrefPos = htmlContent.indexOf("\"", hrefPos + 6);
            String url = htmlContent.substring(hrefPos + 6, endHrefPos);
            return htmlContent.substring(0, hrefPos + 6) + this.rewriteUrl(req, url, fileNameParam) + this.rewriteHrefInHtml(req, tagName, htmlContent.substring(endHrefPos), fileNameParam);
        }
        return htmlContent.substring(0, endA) + this.rewriteHrefInHtml(req, tagName, htmlContent.substring(endA), fileNameParam);
    }

    private String rewriteImportInHtml(HttpServletRequest req, String htmlContent, String fileNameParam) {
        int startImport = htmlContent.indexOf("@import ");
        if (startImport < 0) {
            return htmlContent;
        }
        int endImport = htmlContent.indexOf(";", startImport);
        if (endImport < 0) {
            return htmlContent;
        }
        int startUrl = htmlContent.indexOf("\"", startImport + 8);
        if (startUrl < 0 || startUrl > endImport) {
            return htmlContent.substring(0, endImport) + this.rewriteImportInHtml(req, htmlContent.substring(endImport + 1), fileNameParam);
        }
        int endUrl = htmlContent.indexOf("\"", startUrl + 1);
        if (endUrl < 0 || endUrl > endImport) {
            return htmlContent.substring(0, endImport) + this.rewriteImportInHtml(req, htmlContent.substring(endImport + 1), fileNameParam);
        }
        return htmlContent.substring(0, startUrl + 1) + this.rewriteUrl(req, htmlContent.substring(startUrl + 1, endUrl), fileNameParam) + this.rewriteImportInHtml(req, htmlContent.substring(endUrl), fileNameParam);
    }

    private String rewriteUrl(HttpServletRequest req, String url, String fileNameParam) {
        String param = StringUtils.replace((String)fileNameParam, (String)"\\", (String)"/");
        if (url.startsWith("#")) {
            return url;
        }
        if (url.indexOf("://") > 0) {
            return url;
        }
        if (url.startsWith("/")) {
            return url;
        }
        if (url.startsWith("./")) {
            url = url.substring(2);
        }
        int lastSlash = param.lastIndexOf("/");
        String result = req.getRequestURI() + "?file=";
        String dirName = lastSlash > 0 ? param.substring(0, lastSlash) : param;
        result = result + this.cleanUrl(dirName + "/" + url);
        return result;
    }

    private String cleanUrl(String url) {
        if (url == null) {
            throw new NullPointerException("The url cannot be null.");
        }
        String pathSeparator = "";
        int indexOfDoubleDot = -1;
        if (url.indexOf("../") > 1) {
            pathSeparator = "/";
            indexOfDoubleDot = url.indexOf("../");
        }
        if (url.indexOf("..\\") > 1) {
            pathSeparator = "\\";
            indexOfDoubleDot = url.indexOf("..\\");
        }
        if (indexOfDoubleDot > 1) {
            int startOfTextToRemove = url.substring(0, indexOfDoubleDot - 1).lastIndexOf(pathSeparator);
            String beginUrl = "";
            if (startOfTextToRemove >= 0) {
                beginUrl = url.substring(0, startOfTextToRemove);
            }
            String endUrl = url.substring(indexOfDoubleDot + 3);
            url = beginUrl + pathSeparator + endUrl;
            if (url.indexOf("../") > 1 || url.indexOf("..\\") > 1) {
                url = this.cleanUrl(url);
            }
        }
        return url;
    }
}

