/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.pipeline.valve;

import org.apache.maven.continuum.web.tool.FormToolException;
import org.apache.maven.continuum.web.tool.FormicaTool;
import org.codehaus.plexus.formica.Form;
import org.codehaus.plexus.formica.action.FormInfo;
import org.codehaus.plexus.summit.pipeline.valve.CreateViewContextValve;
import org.codehaus.plexus.summit.pipeline.valve.ValveInvocationException;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.summit.view.ViewContext;
import org.codehaus.plexus.util.StringUtils;

public class FormicaValve
extends CreateViewContextValve {
    public static final String FORMICA_REDIRECT = "formicaRedirect";
    private FormicaTool formicaTool;
    private String defaultFormId;

    protected void populateViewContext(RunData data, ViewContext context) throws ValveInvocationException {
        String formId;
        FormInfo formInfo = (FormInfo)data.getMap().get("formInfo");
        if (formInfo != null) {
            formId = formInfo.getFid();
        } else if (data.getParameters().getString(FORMICA_REDIRECT) != null) {
            String[] s = StringUtils.split((String)data.getParameters().getString(FORMICA_REDIRECT), (String)":");
            formId = s[0];
            data.setTarget(s[1]);
        } else {
            formId = data.getParameters().getString("fid");
        }
        if (formId == null) {
            return;
        }
        String id = data.getParameters().getString("id");
        context.put("id", (Object)id);
        context.put("fid", (Object)formId);
        try {
            Form form = this.formicaTool.getForm(formId);
            context.put("form", (Object)form);
            String view = data.getTarget();
            if (view != null && (view.indexOf("View") >= 0 || view.indexOf("Edit") >= 0)) {
                Object item = this.formicaTool.getItem(form, id);
                context.put("item", item);
            }
        }
        catch (FormToolException e) {
            throw new ValveInvocationException("Error populating context.", (Throwable)e);
        }
    }
}

