/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.xml.LatinEntityResolutionReader;
import org.apache.maven.archiva.xml.XMLException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class XMLReader {
    private URL xmlUrl;
    private String documentType;
    private Document document;
    private Map namespaceMap = new HashMap();

    public XMLReader(String type, File file) throws XMLException {
        if (!file.exists()) {
            throw new XMLException("file does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new XMLException("path is not a file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new XMLException("Cannot read xml file due to permissions: " + file.getAbsolutePath());
        }
        try {
            this.init(type, file.toURL());
        }
        catch (MalformedURLException e) {
            throw new XMLException("Unable to translate file " + file + " to URL: " + e.getMessage(), e);
        }
    }

    public XMLReader(String type, URL url) throws XMLException {
        this.init(type, url);
    }

    private void init(String type, URL url) throws XMLException {
        this.documentType = type;
        this.xmlUrl = url;
        SAXReader reader = new SAXReader();
        try {
            InputStream in = url.openStream();
            InputStreamReader inReader = new InputStreamReader(in, "UTF-8");
            LatinEntityResolutionReader latinReader = new LatinEntityResolutionReader(inReader);
            this.document = reader.read((Reader)latinReader);
        }
        catch (DocumentException e) {
            throw new XMLException("Unable to parse " + this.documentType + " xml " + this.xmlUrl + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLException("Unable to open stream to " + url + ": " + e.getMessage(), e);
        }
        Element root = this.document.getRootElement();
        if (root == null) {
            throw new XMLException("Invalid " + this.documentType + " xml: root element is null.");
        }
        if (!StringUtils.equals((String)root.getName(), (String)this.documentType)) {
            throw new XMLException("Invalid " + this.documentType + " xml: Unexpected root element <" + root.getName() + ">, expected <" + this.documentType + ">");
        }
    }

    public String getDefaultNamespaceURI() {
        Namespace namespace = this.document.getRootElement().getNamespace();
        return namespace.getURI();
    }

    public void addNamespaceMapping(String elementName, String uri) {
        this.namespaceMap.put(elementName, uri);
    }

    public Element getElement(String xpathExpr) throws XMLException {
        XPath xpath = this.createXPath(xpathExpr);
        Node evaluated = xpath.selectSingleNode((Object)this.document);
        if (evaluated == null) {
            return null;
        }
        if (evaluated instanceof Element) {
            Element evalElem = (Element)evaluated;
            return evalElem;
        }
        throw new XMLException(".getElement( Expr: " + xpathExpr + " ) resulted in non-Element type -> (" + evaluated.getClass().getName() + ") " + evaluated);
    }

    private XPath createXPath(String xpathExpr) {
        XPath xpath = this.document.createXPath(xpathExpr);
        if (!this.namespaceMap.isEmpty()) {
            xpath.setNamespaceURIs(this.namespaceMap);
        }
        return xpath;
    }

    public boolean hasElement(String xpathExpr) throws XMLException {
        XPath xpath = this.createXPath(xpathExpr);
        Node evaluated = xpath.selectSingleNode((Object)this.document);
        return evaluated != null;
    }

    public void removeNamespaces() {
        this.removeNamespaces(this.document.getRootElement());
    }

    public void removeNamespaces(Element elem) {
        elem.setQName(QName.get((String)elem.getName(), (Namespace)Namespace.NO_NAMESPACE, (String)elem.getQualifiedName()));
        Iterator it = elem.elementIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            switch (n.getNodeType()) {
                case 2: {
                    ((Attribute)n).setNamespace(Namespace.NO_NAMESPACE);
                    break;
                }
                case 1: {
                    this.removeNamespaces((Element)n);
                }
            }
        }
    }

    public String getElementText(Node context, String xpathExpr) throws XMLException {
        XPath xpath = this.createXPath(xpathExpr);
        Node evaluated = xpath.selectSingleNode((Object)context);
        if (evaluated == null) {
            return null;
        }
        if (evaluated instanceof Element) {
            Element evalElem = (Element)evaluated;
            return evalElem.getTextTrim();
        }
        throw new XMLException(".getElementText( Node, Expr: " + xpathExpr + " ) resulted in non-Element type -> (" + evaluated.getClass().getName() + ") " + evaluated);
    }

    public String getElementText(String xpathExpr) throws XMLException {
        XPath xpath = this.createXPath(xpathExpr);
        Node evaluated = xpath.selectSingleNode((Object)this.document);
        if (evaluated == null) {
            return null;
        }
        if (evaluated instanceof Element) {
            Element evalElem = (Element)evaluated;
            return evalElem.getTextTrim();
        }
        throw new XMLException(".getElementText( Expr: " + xpathExpr + " ) resulted in non-Element type -> (" + evaluated.getClass().getName() + ") " + evaluated);
    }

    public List getElementList(String xpathExpr) throws XMLException {
        XPath xpath = this.createXPath(xpathExpr);
        Object evaluated = xpath.evaluate((Object)this.document);
        if (evaluated == null) {
            return null;
        }
        if (evaluated instanceof List) {
            return (List)evaluated;
        }
        if (evaluated instanceof Node) {
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(evaluated);
            return ret;
        }
        throw new XMLException(".getElementList( Expr: " + xpathExpr + " ) resulted in non-List type -> (" + evaluated.getClass().getName() + ") " + evaluated);
    }

    public List getElementListText(String xpathExpr) throws XMLException {
        List elemList = this.getElementList(xpathExpr);
        if (elemList == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Element listelem : elemList) {
            ret.add(listelem.getTextTrim());
        }
        return ret;
    }
}

