/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.archiva.dependency.graph.DependencyGraphUtils;
import org.apache.maven.archiva.dependency.graph.GraphTask;
import org.apache.maven.archiva.dependency.graph.GraphTaskException;
import org.apache.maven.archiva.dependency.graph.tasks.DependencyManagementApplier;
import org.apache.maven.archiva.dependency.graph.tasks.ResolveGraphTask;
import org.apache.maven.archiva.dependency.graph.walk.WalkDepthFirstSearch;

public class PopulateGraphMasterTask
implements GraphTask {
    private DependencyGraphBuilder builder;
    private ResolveGraphTask resolveGraphTask = new ResolveGraphTask();
    private DependencyManagementApplier depManApplier = new DependencyManagementApplier();

    public void executeTask(DependencyGraph graph) throws GraphTaskException {
        WalkDepthFirstSearch walker = new WalkDepthFirstSearch();
        boolean done = false;
        int maxiters = 5;
        while (!done) {
            this.resolveGraphTask.executeTask(graph);
            walker.visit(graph, this.depManApplier);
            if (!this.depManApplier.hasCreatedNodes() || maxiters < 0) {
                done = true;
                break;
            }
            --maxiters;
        }
        DependencyGraphUtils.cleanupOrphanedNodes(graph);
    }

    public String getTaskId() {
        return "populate-graph";
    }

    public DependencyGraphBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DependencyGraphBuilder builder) {
        this.builder = builder;
        this.resolveGraphTask.setBuilder(builder);
        this.depManApplier.setBuilder(builder);
    }
}

