/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.zookeeper.services;

import at.salzburgresearch.nodekeeper.NodeKeeper;
import at.salzburgresearch.nodekeeper.NodeListener;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.events.ConfigurationServiceInitEvent;
import org.apache.marmotta.platform.zookeeper.api.ZookeeperService;
import org.apache.marmotta.platform.zookeeper.event.ZookeeperInitEvent;
import org.apache.marmotta.platform.zookeeper.listeners.ConfigurationListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;

@ApplicationScoped
public class ZookeeperServiceImpl
implements ZookeeperService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    @Any
    private Event<ZookeeperInitEvent> zookeeperInitEvent;
    private NodeKeeper nodeKeeper;
    private Properties properties;
    private String datacenterIdPath;

    public void initialise(@Observes ConfigurationServiceInitEvent event) throws IOException, InterruptedException {
        this.log.warn("Activating Marmotta Zookeeper Bridge");
        String connectionString = this.configurationService.getContextParam("zookeeper.server");
        if (connectionString != null) {
            this.log.info(" - connection string: {}", (Object)connectionString);
            this.properties = new Properties();
            File nkProperties = new File(this.configurationService.getHome() + File.separator + "nodekeeper.properties");
            if (nkProperties.exists()) {
                this.properties.load(new FileInputStream(nkProperties));
            }
            if (StringUtils.isBlank((String)this.configurationService.getStringConfiguration("zookeeper.instance"))) {
                String instanceId = StringUtils.isBlank((String)this.configurationService.getContextParam("zookeeper.instance")) ? UUID.randomUUID().toString() : this.configurationService.getContextParam("zookeeper.instance");
                this.configurationService.setConfiguration("zookeeper.instance", instanceId);
            }
            if (StringUtils.isBlank((String)this.configurationService.getStringConfiguration("zookeeper.cluster"))) {
                String clusterId = StringUtils.isBlank((String)this.configurationService.getContextParam("zookeeper.cluster")) ? "default" : this.configurationService.getContextParam("zookeeper.cluster");
                this.configurationService.setConfiguration("zookeeper.cluster", clusterId);
            }
            this.log.info(" - initialize nodekeeper connection for instance {} (cluster {})", (Object)this.configurationService.getStringConfiguration("zookeeper.instance"), (Object)this.configurationService.getStringConfiguration("zookeeper.cluster"));
            try {
                this.nodeKeeper = new NodeKeeper(connectionString, this.configurationService.getIntConfiguration("zookeeper.timeout", 60000), this.properties, null);
                this.initZooKeeper();
                String uuid = this.configurationService.getStringConfiguration("zookeeper.instance", UUID.randomUUID().toString());
                String cluster = this.configurationService.getStringConfiguration("zookeeper.cluster", "default");
                ConfigurationListener listener = new ConfigurationListener(this.configurationService, this.nodeKeeper);
                this.nodeKeeper.addListener("/marmotta/config/[^/]+", (NodeListener)listener);
                this.nodeKeeper.addListener(String.format("/marmotta/clusters/%s/config/[^/]+", cluster), (NodeListener)listener);
                this.nodeKeeper.addListener(String.format("/marmotta/clusters/%s/instances/%s/config/[^/]+", cluster, uuid), (NodeListener)listener);
                this.nodeKeeper.startListeners();
                this.log.info("... running");
                this.zookeeperInitEvent.fire((Object)new ZookeeperInitEvent());
            }
            catch (KeeperException ex) {
                this.log.error("could not initialise Zookeeper: {}", (Object)ex.getMessage());
            }
            catch (NodeKeeperException e) {
                this.log.error("could not initialise NodeKeeper: {}", (Object)e.getMessage());
            }
        } else {
            this.log.warn("no Zookeeper servers configured, Zookeeper Integration not available");
        }
    }

    @PreDestroy
    private void shutdown() {
        try {
            this.log.info("ZOOKEEPER: deactivating Zookeeper Bridge ...");
            if (this.nodeKeeper != null) {
                String cluster = this.configurationService.getStringConfiguration("zookeeper.cluster", "default");
                this.log.info("- removing lock on datacenter id");
                this.nodeKeeper.getZooKeeper().delete(String.format(this.datacenterIdPath, cluster), -1);
                this.log.info(" - closing nodekeeper connection");
                this.nodeKeeper.shutdown();
                this.log.info("   ... closed");
            }
            if (this.properties != null) {
                File nkProperties = new File(this.configurationService.getHome() + File.separator + "nodekeeper.properties");
                this.properties.store(new FileOutputStream(nkProperties), "automatic nodekeeper state");
            }
        }
        catch (IOException | InterruptedException | KeeperException e) {
            this.log.error("ZOOKEEPER: exception while shutting down Zookeeper connection ({})", (Object)e.getMessage());
        }
    }

    private void initZooKeeper() throws KeeperException, InterruptedException, IOException {
        if (this.nodeKeeper == null || this.nodeKeeper.getZooKeeper() == null) {
            this.log.error("ZooKeeper not available");
        } else {
            String uuid = this.configurationService.getStringConfiguration("zookeeper.instance", UUID.randomUUID().toString());
            String cluster = this.configurationService.getStringConfiguration("zookeeper.cluster", "default");
            this.createNodeIfNotExists("/marmotta");
            this.createNodeIfNotExists("/marmotta/config");
            this.createNodeIfNotExists("/marmotta/clusters");
            this.createNodeIfNotExists(String.format("/marmotta/clusters/%s", cluster));
            this.createNodeIfNotExists(String.format("/marmotta/clusters/%s/config", cluster));
            this.createNodeIfNotExists(String.format("/marmotta/clusters/%s/snowflake", cluster));
            this.createNodeIfNotExists(String.format("/marmotta/clusters/%s/instances", cluster));
            this.createNodeIfNotExists(String.format("/marmotta/clusters/%s/instances/%s", cluster, uuid));
            this.createNodeIfNotExists(String.format("/marmotta/clusters/%s/instances/%s/config", cluster, uuid));
            this.datacenterIdPath = this.nodeKeeper.getZooKeeper().create(String.format("/marmotta/clusters/%s/snowflake/id-", cluster), new String("creator:" + uuid).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            int datacenterId = Integer.parseInt(this.datacenterIdPath.substring(this.datacenterIdPath.lastIndexOf("id-") + 3)) % 4096;
            this.log.info("ZOOKEEPER: generated datacenter ID {}", (Object)datacenterId);
            this.configurationService.setIntConfiguration("database.datacenter.id", datacenterId);
        }
    }

    private void createNodeIfNotExists(String path) throws KeeperException, InterruptedException {
        if (this.nodeKeeper.getZooKeeper().exists(path, false) == null) {
            String uuid = this.configurationService.getStringConfiguration("zookeeper.instance", UUID.randomUUID().toString());
            this.nodeKeeper.getZooKeeper().create(path, new String("creator:" + uuid).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }
}

