/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.webservices;

import info.aduna.iteration.Iterations;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.marmotta.commons.util.DateUtils;
import org.apache.marmotta.commons.util.JSONUtils;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.events.SystemStartupEvent;
import org.apache.marmotta.platform.versioning.services.VersioningSailProvider;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/")
public class VersioningWebService {
    @Inject
    private Logger log;
    @Inject
    private VersioningSailProvider versioningService;
    @Inject
    private SesameService sesameService;
    @Inject
    private ConfigurationService configurationService;

    public void startup(@Observes SystemStartupEvent event) {
        if (this.configurationService.getBooleanConfiguration("versioning.memento", true)) {
            this.log.info("Versioning Service: enabling Memento support");
            this.configurationService.setRuntimeFlag("create_memento_links", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json"})
    @Path(value="/versions/list")
    public Response getVersions(@QueryParam(value="resource") String resource_uri, @QueryParam(value="from") String dateFrom, @QueryParam(value="to") String dateTo) {
        try {
            RepositoryConnection conn = this.sesameService.getConnection();
            try {
                if (resource_uri != null) {
                    URI resource = conn.getValueFactory().createURI(resource_uri);
                    if (resource != null && resource instanceof KiWiUriResource) {
                        if (dateFrom == null && dateTo == null) {
                            Response response = Response.ok().entity(this.formatVersions(this.versioningService.listVersions((Resource)resource))).build();
                            return response;
                        }
                        Date dateFromD = DateUtils.parseDate((String)dateFrom);
                        Date dateToD = DateUtils.parseDate((String)dateTo);
                        Response response = Response.ok().entity(this.formatVersions(this.versioningService.listVersions((Resource)resource, dateFromD, dateToD))).build();
                        return response;
                    }
                    Response dateFromD = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("resource with URI " + resource_uri + " was not found in the system")).build();
                    return dateFromD;
                }
                if (dateFrom == null && dateTo == null) {
                    Response resource = Response.ok().entity(this.formatVersions(this.versioningService.listVersions())).build();
                    return resource;
                }
                Date dateFromD = DateUtils.parseDate((String)dateFrom);
                Date dateToD = DateUtils.parseDate((String)dateTo);
                Response response = Response.ok().entity(this.formatVersions(this.versioningService.listVersions(dateFromD, dateToD))).build();
                return response;
            }
            finally {
                conn.commit();
                conn.close();
            }
        }
        catch (RepositoryException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
        catch (SailException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
    }

    private List<Map<String, Object>> formatVersions(RepositoryResult<Version> versions) throws RepositoryException {
        return this.formatVersions(Iterations.asList(versions));
    }

    private List<Map<String, Object>> formatVersions(List<Version> versions) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(versions.size());
        for (Version version : versions) {
            HashMap<String, Object> v_map = new HashMap<String, Object>();
            v_map.put("id", version.getId());
            if (version.getCreator() != null) {
                v_map.put("creator", version.getCreator().stringValue());
            }
            v_map.put("date", DateUtils.ISO8601FORMAT.format(version.getCommitTime()));
            result.add(v_map);
        }
        return result;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/versions/{id:[0-9]+}")
    public Response getVersion(@PathParam(value="id") Long id) {
        try {
            Version version = this.versioningService.getVersion(id);
            if (version != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("id", version.getId());
                if (version.getCreator() != null) {
                    result.put("creator", version.getCreator().stringValue());
                }
                result.put("date", DateUtils.ISO8601FORMAT.format(version.getCommitTime()));
                result.put("added_triples", JSONUtils.serializeTriplesAsJson((Iterable)version.getAddedTriples()));
                result.put("removed_triples", JSONUtils.serializeTriplesAsJson((Iterable)version.getRemovedTriples()));
                return Response.ok().entity(result).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("version with id " + id + " does not exist")).build();
        }
        catch (SailException e) {
            return Response.serverError().entity((Object)("error loading version " + id + ": " + e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/versions/{id:[0-9]+}")
    public Response deleteVersion(@PathParam(value="id") Long id) {
        try {
            Version version = this.versioningService.getVersion(id);
            if (version != null) {
                this.versioningService.removeVersion(id);
                return Response.ok().entity((Object)"success").build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("version with id " + id + " does not exist")).build();
        }
        catch (SailException e) {
            return Response.serverError().entity((Object)("error deleting version " + id + ": " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/versions/{id:[0-9]+}")
    public Response revertVersion(@PathParam(value="id") Long id) {
        try {
            Version version = this.versioningService.getVersion(id);
            if (version != null) {
                this.versioningService.removeVersion(id);
                return Response.ok().entity((Object)"success").build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("version with id " + id + " does not exist")).build();
        }
        catch (SailException e) {
            return Response.serverError().entity((Object)("error deleting version " + id + ": " + e.getMessage())).build();
        }
    }
}

