/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.services;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.platform.versioning.api.MementoService;
import org.apache.marmotta.platform.versioning.exception.MementoException;
import org.apache.marmotta.platform.versioning.model.MementoVersionSet;
import org.apache.marmotta.platform.versioning.services.VersioningSailProvider;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.sail.SailException;

@ApplicationScoped
public class MementoServiceImpl
implements MementoService {
    @Inject
    VersioningSailProvider versioningService;

    @Override
    public Version getVersion(Resource resource, Date date) throws MementoException {
        try {
            return this.versioningService.getLatestVersion(resource, date);
        }
        catch (SailException e) {
            throw new MementoException("version for " + date + " cannot be returned");
        }
    }

    @Override
    public MementoVersionSet getVersionSet(Resource resource, Date date) throws MementoException {
        try {
            MementoVersionSet versionset = new MementoVersionSet(resource);
            versionset.setCurrent(this.versioningService.getLatestVersion(resource, date));
            RepositoryResult<Version> versions = this.versioningService.listVersions(resource);
            while (versions.hasNext()) {
                Version v = (Version)versions.next();
                if (versionset.getCurrent() == null) {
                    versionset.setCurrent(v);
                }
                if (versionset.getFirst() == null) {
                    versionset.setFirst(v);
                }
                versionset.setLast(v);
                if (v.getId() < versionset.getCurrent().getId()) {
                    versionset.setPrevious(v);
                }
                if (v.getId() <= versionset.getCurrent().getId() || versionset.getNext() != null) continue;
                versionset.setNext(v);
            }
            return versionset;
        }
        catch (SailException e) {
            throw new MementoException("cannot list versions");
        }
        catch (RepositoryException e) {
            throw new MementoException("cannot produce version result set");
        }
    }
}

