/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.sparql;

import info.aduna.iteration.Iteration;
import org.apache.marmotta.commons.sesame.test.sparql.SparqlMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openrdf.model.Resource;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class SparqlGraphQueryMatcher<T extends RepositoryConnection>
extends SparqlMatcher<T> {
    private final Matcher<? extends RepositoryConnection>[] matchers;

    @SafeVarargs
    protected SparqlGraphQueryMatcher(String baseUri, String query, Matcher<? extends RepositoryConnection> ... matchers) {
        super(baseUri, query);
        this.matchers = matchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean matchesSPARQL(RepositoryConnection connection) throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        GraphQuery graphQuery = connection.prepareGraphQuery(QueryLanguage.SPARQL, this.query, this.baseUri);
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.initialize();
        try {
            boolean bl;
            RepositoryConnection connection2 = repo.getConnection();
            try {
                connection2.begin();
                try (GraphQueryResult graph = graphQuery.evaluate();){
                    connection2.add((Iteration)graph, new Resource[0]);
                }
                connection2.commit();
                boolean result = true;
                for (Matcher<? extends RepositoryConnection> matcher : this.matchers) {
                    connection2.begin();
                    result &= matcher.matches((Object)connection2);
                    connection2.commit();
                }
                bl = result;
            }
            catch (Throwable throwable) {
                connection2.close();
                throw throwable;
            }
            connection2.close();
            return bl;
        }
        finally {
            repo.shutDown();
        }
    }

    public void describeTo(Description description) {
        description.appendText(" Graph ").appendValue((Object)this.query).appendText(" ");
        if (this.matchers.length == 1) {
            description.appendDescriptionOf(this.matchers[0]);
        } else {
            for (Matcher<? extends RepositoryConnection> matcher : this.matchers) {
                description.appendText("\n  ").appendDescriptionOf(matcher);
            }
        }
    }

    public static <T extends RepositoryConnection> Matcher<T> sparqlGraphQuery(String baseUri, String query, Matcher<? extends RepositoryConnection> matcher) {
        return new SparqlGraphQueryMatcher<T>(baseUri, query, matcher);
    }

    @SafeVarargs
    public static <T extends RepositoryConnection> Matcher<T> sparqlGraphQuery(String baseUri, String query, Matcher<? extends RepositoryConnection> ... matchers) {
        return new SparqlGraphQueryMatcher<T>(baseUri, query, matchers);
    }
}

