/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.base;

import org.apache.marmotta.commons.sesame.test.base.SesameMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;

public class RepositoryMatcher<T extends Repository>
extends SesameMatcher<T>
implements Matcher<T> {
    private final Matcher<? extends RepositoryConnection>[] delegates;

    public RepositoryMatcher(Matcher<? extends RepositoryConnection> ... delegates) {
        this.delegates = delegates;
    }

    protected boolean matchesSafely(Repository repository) {
        boolean bl;
        RepositoryConnection con = repository.getConnection();
        try {
            boolean matches = true;
            for (Matcher<? extends RepositoryConnection> delegate : this.delegates) {
                con.begin();
                matches &= delegate.matches((Object)con);
                con.commit();
            }
            bl = matches;
        }
        catch (Throwable t) {
            try {
                try {
                    con.rollback();
                    throw t;
                }
                catch (Throwable throwable) {
                    con.close();
                    throw throwable;
                }
            }
            catch (RuntimeException r) {
                throw r;
            }
            catch (Exception e) {
                return false;
            }
        }
        con.close();
        return bl;
    }

    public void describeTo(Description description) {
        description.appendText(" a SesameRepositoy ");
        for (int i = 0; i < this.delegates.length; ++i) {
            Matcher<? extends RepositoryConnection> delegate = this.delegates[i];
            if (i > 0) {
                description.appendText(",\n and ");
            }
            description.appendDescriptionOf(delegate);
        }
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        mismatchDescription.appendText(" a SesameRepositoy ");
        for (int i = 0; i < this.delegates.length; ++i) {
            Matcher<? extends RepositoryConnection> delegate = this.delegates[i];
            if (i > 0) {
                mismatchDescription.appendText(",\n and ");
            }
            delegate.describeMismatch(item, mismatchDescription);
        }
    }

    public static <T extends Repository> Matcher<T> wrap(Matcher<? extends RepositoryConnection> connectionMatcher) {
        return new RepositoryMatcher<T>(connectionMatcher);
    }

    public static <T extends Repository> Matcher<T> wrap(Matcher<? extends RepositoryConnection> ... connectionMatchers) {
        return new RepositoryMatcher<T>(connectionMatchers);
    }
}

